/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.LongFVComparator;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.knn.LongNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class ExactLongAssigner
implements HardAssigner<long[], double[], IntDoublePair> {
    protected LongNearestNeighboursExact nn;

    public ExactLongAssigner(CentroidsProvider<long[]> provider) {
        this(provider, null);
    }

    public ExactLongAssigner(CentroidsProvider<long[]> provider, LongFVComparison comparison) {
        this.nn = new LongNearestNeighboursExact((long[][])provider.getCentroids(), (LongFVComparator)comparison);
    }

    public ExactLongAssigner(long[][] data, LongFVComparison comparison) {
        this.nn = new LongNearestNeighboursExact(data, (LongFVComparator)comparison);
    }

    public int[] assign(long[][] data) {
        int[] argmins = new int[data.length];
        double[] mins = new double[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(long[] data) {
        return this.assign(new long[][]{data})[0];
    }

    public void assignDistance(long[][] data, int[] indices, double[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntDoublePair assignDistance(long[] data) {
        int[] index = new int[1];
        double[] distance = new double[1];
        this.nn.searchNN((long[][])new long[][]{data}, index, distance);
        return new IntDoublePair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public LongNearestNeighboursExact getNN() {
        return this.nn;
    }
}

