/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.LongNearestNeighboursProvider;
import org.openimaj.knn.approximate.LongNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class KDTreeLongEuclideanAssigner
implements HardAssigner<long[], double[], IntDoublePair> {
    protected LongNearestNeighboursKDTree nn;

    public KDTreeLongEuclideanAssigner(CentroidsProvider<long[]> provider) {
        LongNearestNeighbours internal;
        if (provider instanceof LongNearestNeighboursProvider && (internal = ((LongNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof LongNearestNeighboursKDTree) {
            this.nn = (LongNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new LongNearestNeighboursKDTree((long[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeLongEuclideanAssigner(long[][] data) {
        this.nn = new LongNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(long[][] data) {
        int[] argmins = new int[data.length];
        double[] mins = new double[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(long[] data) {
        return this.assign(new long[][]{data})[0];
    }

    public void assignDistance(long[][] data, int[] indices, double[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntDoublePair assignDistance(long[] data) {
        int[] index = new int[1];
        double[] distance = new double[1];
        this.nn.searchNN((long[][])new long[][]{data}, index, distance);
        return new IntDoublePair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

