/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.LongFVComparator;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.LongNearestNeighboursExact;
import org.openimaj.knn.LongNearestNeighboursProvider;
import org.openimaj.knn.approximate.LongNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class LongKNNAssigner
implements SoftAssigner<long[], double[]> {
    protected LongNearestNeighbours nn;
    protected int numNeighbours;

    public LongKNNAssigner(CentroidsProvider<long[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new LongNearestNeighboursExact((long[][])provider.getCentroids());
        } else {
            LongNearestNeighbours internal;
            if (provider instanceof LongNearestNeighboursProvider && (internal = ((LongNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof LongNearestNeighboursKDTree) {
                this.nn = (LongNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new LongNearestNeighboursKDTree((long[][])provider.getCentroids(), 8, 768);
        }
    }

    public LongKNNAssigner(long[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new LongNearestNeighboursExact(data) : new LongNearestNeighboursKDTree(data, 8, 768);
    }

    public LongKNNAssigner(CentroidsProvider<long[]> provider, LongFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new LongNearestNeighboursExact((long[][])provider.getCentroids(), (LongFVComparator)comparison);
    }

    public LongKNNAssigner(long[][] data, LongFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new LongNearestNeighboursExact(data, (LongFVComparator)comparison);
    }

    public int[][] assign(long[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        double[][] distances = new double[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(long[] data) {
        return this.assign(new long[][]{data})[0];
    }

    public void assignWeighted(long[][] data, int[][] assignments, double[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], double[]> assignWeighted(long[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        double[][] distances = new double[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new long[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

