/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.openimaj.data.DataSource;
import org.openimaj.data.FloatArrayBackedDataSource;
import org.openimaj.knn.FloatNearestNeighbours;
import org.openimaj.knn.FloatNearestNeighboursExact;
import org.openimaj.knn.FloatNearestNeighboursProvider;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.approximate.FloatNearestNeighboursKDTree;
import org.openimaj.ml.clustering.FloatCentroidsResult;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactFloatAssigner;
import org.openimaj.ml.clustering.assignment.hard.KDTreeFloatEuclideanAssigner;
import org.openimaj.ml.clustering.kmeans.FloatKMeansInit;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.util.pair.IntFloatPair;

public class FloatKMeans
implements SpatialClusterer<FloatCentroidsResult, float[]> {
    private FloatKMeansInit init = new FloatKMeansInit.RANDOM();
    private KMeansConfiguration<FloatNearestNeighbours, float[]> conf;
    private Random rng = new Random();

    public FloatKMeans(KMeansConfiguration<FloatNearestNeighbours, float[]> conf) {
        this.conf = conf;
    }

    protected FloatKMeans() {
        this(new KMeansConfiguration<FloatNearestNeighbours, float[]>());
    }

    public FloatKMeansInit getInit() {
        return this.init;
    }

    public void setInit(FloatKMeansInit init) {
        this.init = init;
    }

    public void seed(long seed) {
        this.rng = seed < 0L ? new Random() : new Random(seed);
    }

    public FloatCentroidsResult cluster(float[][] data) {
        FloatArrayBackedDataSource ds = new FloatArrayBackedDataSource(data, this.rng);
        try {
            Result result = this.cluster((DataSource<float[]>)ds, this.conf.K);
            result.nn = (FloatNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] performClustering(float[][] data) {
        FloatCentroidsResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    protected Result cluster(DataSource<float[]> data, int K) throws Exception {
        int D = data.numDimensions();
        Result result = new Result();
        result.centroids = new float[K][D];
        this.init.initKMeans(data, result.centroids);
        this.cluster(data, result);
        return result;
    }

    protected void cluster(DataSource<float[]> data, Result result) throws Exception {
        float[][] centroids = result.centroids;
        int K = centroids.length;
        int D = centroids[0].length;
        int N = data.numRows();
        float[][] centroids_accum = new float[K][D];
        int[] new_counts = new int[K];
        ExecutorService service = this.conf.threadpool;
        for (int i = 0; i < this.conf.niters; ++i) {
            for (int j = 0; j < K; ++j) {
                Arrays.fill(centroids_accum[j], 0.0f);
            }
            Arrays.fill(new_counts, 0);
            FloatNearestNeighbours nno = (FloatNearestNeighbours)this.conf.factory.create((Object[])centroids);
            ArrayList<CentroidAssignmentJob> jobs = new ArrayList<CentroidAssignmentJob>();
            for (int bl = 0; bl < N; bl += this.conf.blockSize) {
                int br = Math.min(bl + this.conf.blockSize, N);
                jobs.add(new CentroidAssignmentJob(data, bl, br, nno, centroids_accum, new_counts));
            }
            service.invokeAll(jobs);
            for (int k = 0; k < K; ++k) {
                if (new_counts[k] == 0) {
                    new_counts[k] = 1;
                    float[][] rnd = new float[][]{centroids[k]};
                    data.getRandomRows((Object[])rnd);
                    continue;
                }
                for (int d = 0; d < D; ++d) {
                    centroids[k][d] = this.roundFloat((double)centroids_accum[k][d] / (double)new_counts[k]);
                }
            }
        }
    }

    protected float roundFloat(double value) {
        return (float)value;
    }

    protected double roundDouble(double value) {
        return value;
    }

    protected long roundLong(double value) {
        return Math.round(value);
    }

    protected int roundInt(double value) {
        return (int)Math.round(value);
    }

    @Override
    public FloatCentroidsResult cluster(DataSource<float[]> ds) {
        try {
            Result result = this.cluster(ds, this.conf.K);
            result.nn = (FloatNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KMeansConfiguration<FloatNearestNeighbours, float[]> getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(KMeansConfiguration<FloatNearestNeighbours, float[]> conf) {
        this.conf = conf;
    }

    public static FloatKMeans createExact(int K) {
        KMeansConfiguration<FloatNearestNeighbours, float[]> conf = new KMeansConfiguration<FloatNearestNeighbours, float[]>(K, (NearestNeighboursFactory<FloatNearestNeighbours, float[]>)new FloatNearestNeighboursExact.Factory());
        return new FloatKMeans(conf);
    }

    public static FloatKMeans createExact(int K, int niters) {
        KMeansConfiguration<FloatNearestNeighbours, float[]> conf = new KMeansConfiguration<FloatNearestNeighbours, float[]>(K, (NearestNeighboursFactory<FloatNearestNeighbours, float[]>)new FloatNearestNeighboursExact.Factory(), niters);
        return new FloatKMeans(conf);
    }

    public static FloatKMeans createKDTreeEnsemble(int K) {
        KMeansConfiguration<FloatNearestNeighbours, float[]> conf = new KMeansConfiguration<FloatNearestNeighbours, float[]>(K, (NearestNeighboursFactory<FloatNearestNeighbours, float[]>)new FloatNearestNeighboursKDTree.Factory());
        return new FloatKMeans(conf);
    }

    public String toString() {
        return String.format("%s: {K=%d, NN=%s}", this.getClass().getSimpleName(), this.conf.K, this.conf.getNearestNeighbourFactory().getClass().getSimpleName());
    }

    private static class Result
    extends FloatCentroidsResult
    implements FloatNearestNeighboursProvider {
        protected FloatNearestNeighbours nn;

        private Result() {
        }

        @Override
        public HardAssigner<float[], float[], IntFloatPair> defaultHardAssigner() {
            if (this.nn instanceof FloatNearestNeighboursExact) {
                return new ExactFloatAssigner(this);
            }
            return new KDTreeFloatEuclideanAssigner(this);
        }

        public FloatNearestNeighbours getNearestNeighbours() {
            return this.nn;
        }
    }

    private static class CentroidAssignmentJob
    implements Callable<Boolean> {
        private final DataSource<float[]> ds;
        private final int startRow;
        private final int stopRow;
        private final FloatNearestNeighbours nno;
        private final float[][] centroids_accum;
        private final int[] counts;

        public CentroidAssignmentJob(DataSource<float[]> ds, int startRow, int stopRow, FloatNearestNeighbours nno, float[][] centroids_accum, int[] counts) {
            this.ds = ds;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.nno = nno;
            this.centroids_accum = centroids_accum;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                int D = this.nno.numDimensions();
                float[][] points = new float[this.stopRow - this.startRow][D];
                this.ds.getData(this.startRow, this.stopRow, (Object[])points);
                int[] argmins = new int[points.length];
                float[] mins = new float[points.length];
                this.nno.searchNN((Object[])points, argmins, (Object)mins);
                float[][] fArray = this.centroids_accum;
                synchronized (this.centroids_accum) {
                    for (int i = 0; i < points.length; ++i) {
                        int k = argmins[i];
                        for (int d = 0; d < D; ++d) {
                            float[] fArray2 = this.centroids_accum[k];
                            int n = d;
                            fArray2[n] = fArray2[n] + points[i][d];
                        }
                        int n = k;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return true;
            }
        }
    }
}

