/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.data.IndexedViewDataSource;
import org.openimaj.knn.ShortNearestNeighbours;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalShortKMeansResult;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.ml.clustering.kmeans.ShortKMeans;
import org.openimaj.util.pair.IntFloatPair;

@Reference(type=ReferenceType.Inproceedings, author={"David. Nist'er", "Henrik. Stew'enius"}, title="Scalable Recognition with a Vocabulary Tree", year="2006", booktitle="CVPR", pages={"2161", "", "2168"}, customData={"Date-Added", "2010-11-12 09:33:18 +0000", "Date-Modified", "2010-11-22 15:11:22 +0000"})
public class HierarchicalShortKMeans
implements SpatialClusterer<HierarchicalShortKMeansResult, short[]> {
    int M;
    int K;
    KMeansConfiguration<ShortNearestNeighbours, short[]> conf;
    int depth;

    public HierarchicalShortKMeans(KMeansConfiguration<ShortNearestNeighbours, short[]> config, int M, int K, int depth) {
        this.conf = config;
        this.M = M;
        this.K = K;
        this.depth = depth;
    }

    public HierarchicalShortKMeans(int M, int K, int depth) {
        this(new KMeansConfiguration<ShortNearestNeighbours, short[]>(), M, K, depth);
    }

    private short[][] extractSubset(short[][] data, int[] ids, int id) {
        int N = data.length;
        int M = data[0].length;
        int count = 0;
        for (int i = 0; i < N; ++i) {
            if (ids[i] != id) continue;
            ++count;
        }
        short[][] newData = new short[count][M];
        count = 0;
        for (int i = 0; i < N; ++i) {
            if (ids[i] != id) continue;
            System.arraycopy(data[i], 0, newData[count], 0, M);
            ++count;
        }
        return newData;
    }

    private HierarchicalShortKMeansResult.Node trainLevel(short[][] data, int K, int height) {
        HierarchicalShortKMeansResult.Node node = new HierarchicalShortKMeansResult.Node();
        node.children = height == 1 ? null : new HierarchicalShortKMeansResult.Node[K];
        ShortKMeans kmeans = this.newShortKMeans(K);
        node.result = kmeans.cluster(data);
        HardAssigner<short[], float[], IntFloatPair> assigner = node.result.defaultHardAssigner();
        if (height > 1) {
            int[] ids = assigner.assign((DATATYPE[])data);
            for (int k = 0; k < K; ++k) {
                short[][] partition = this.extractSubset(data, ids, k);
                int partitionK = Math.min(K, partition.length);
                node.children[k] = this.trainLevel(partition, partitionK, height - 1);
            }
        }
        return node;
    }

    private HierarchicalShortKMeansResult.Node trainLevel(DataSource<short[]> data, int K, int height) {
        HierarchicalShortKMeansResult.Node node = new HierarchicalShortKMeansResult.Node();
        node.children = height == 1 ? null : new HierarchicalShortKMeansResult.Node[K];
        ShortKMeans kmeans = this.newShortKMeans(K);
        node.result = kmeans.cluster((DataSource)data);
        HardAssigner<short[], float[], IntFloatPair> assigner = node.result.defaultHardAssigner();
        if (height > 1) {
            TIntObjectHashMap assignments = new TIntObjectHashMap();
            short[][] tmp = new short[1][this.M];
            for (int i = 0; i < data.numRows(); ++i) {
                data.getData(i, i + 1, (Object[])tmp);
                int asgn = assigner.assign(tmp[0]);
                TIntArrayList ids = (TIntArrayList)assignments.get(asgn);
                if (ids == null) {
                    ids = new TIntArrayList();
                    assignments.put(asgn, (Object)ids);
                }
                ids.add(i);
            }
            for (int k = 0; k < K; ++k) {
                int[] indexes = ((TIntArrayList)assignments.get(k)).toArray();
                IndexedViewDataSource partition = new IndexedViewDataSource(data, indexes);
                int partitionK = Math.min(K, partition.numRows());
                node.children[k] = this.trainLevel((DataSource<short[]>)partition, partitionK, height - 1);
            }
        }
        return node;
    }

    public HierarchicalShortKMeansResult cluster(short[][] data) {
        HierarchicalShortKMeansResult result = new HierarchicalShortKMeansResult();
        result.K = this.K;
        result.M = this.M;
        result.depth = this.depth;
        result.root = this.trainLevel(data, Math.min(this.K, data.length), this.depth);
        return result;
    }

    public int[][] performClustering(short[][] data) {
        HierarchicalShortKMeansResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign(data)).clusters();
    }

    @Override
    public HierarchicalShortKMeansResult cluster(DataSource<short[]> data) {
        HierarchicalShortKMeansResult result = new HierarchicalShortKMeansResult();
        result.K = this.K;
        result.M = this.M;
        result.depth = this.depth;
        result.root = this.trainLevel(data, Math.min(this.K, data.numRows()), this.depth);
        return result;
    }

    private ShortKMeans newShortKMeans(int K) {
        Object newConf = this.conf.clone();
        ((KMeansConfiguration)newConf).setK(K);
        return new ShortKMeans((KMeansConfiguration<ShortNearestNeighbours, short[]>)newConf);
    }
}

