/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.openimaj.data.DataSource;
import org.openimaj.data.LongArrayBackedDataSource;
import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.LongNearestNeighboursExact;
import org.openimaj.knn.LongNearestNeighboursProvider;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.approximate.LongNearestNeighboursKDTree;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.LongCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactLongAssigner;
import org.openimaj.ml.clustering.assignment.hard.KDTreeLongEuclideanAssigner;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.ml.clustering.kmeans.LongKMeansInit;
import org.openimaj.util.pair.IntDoublePair;

public class LongKMeans
implements SpatialClusterer<LongCentroidsResult, long[]> {
    private LongKMeansInit init = new LongKMeansInit.RANDOM();
    private KMeansConfiguration<LongNearestNeighbours, long[]> conf;
    private Random rng = new Random();

    public LongKMeans(KMeansConfiguration<LongNearestNeighbours, long[]> conf) {
        this.conf = conf;
    }

    protected LongKMeans() {
        this(new KMeansConfiguration<LongNearestNeighbours, long[]>());
    }

    public LongKMeansInit getInit() {
        return this.init;
    }

    public void setInit(LongKMeansInit init) {
        this.init = init;
    }

    public void seed(long seed) {
        this.rng = seed < 0L ? new Random() : new Random(seed);
    }

    public LongCentroidsResult cluster(long[][] data) {
        LongArrayBackedDataSource ds = new LongArrayBackedDataSource(data, this.rng);
        try {
            Result result = this.cluster((DataSource<long[]>)ds, this.conf.K);
            result.nn = (LongNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] performClustering(long[][] data) {
        LongCentroidsResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    protected Result cluster(DataSource<long[]> data, int K) throws Exception {
        int D = data.numDimensions();
        Result result = new Result();
        result.centroids = new long[K][D];
        this.init.initKMeans(data, result.centroids);
        this.cluster(data, result);
        return result;
    }

    protected void cluster(DataSource<long[]> data, Result result) throws Exception {
        long[][] centroids = result.centroids;
        int K = centroids.length;
        int D = centroids[0].length;
        int N = data.numRows();
        double[][] centroids_accum = new double[K][D];
        int[] new_counts = new int[K];
        ExecutorService service = this.conf.threadpool;
        for (int i = 0; i < this.conf.niters; ++i) {
            for (int j = 0; j < K; ++j) {
                Arrays.fill(centroids_accum[j], 0.0);
            }
            Arrays.fill(new_counts, 0);
            LongNearestNeighbours nno = (LongNearestNeighbours)this.conf.factory.create((Object[])centroids);
            ArrayList<CentroidAssignmentJob> jobs = new ArrayList<CentroidAssignmentJob>();
            for (int bl = 0; bl < N; bl += this.conf.blockSize) {
                int br = Math.min(bl + this.conf.blockSize, N);
                jobs.add(new CentroidAssignmentJob(data, bl, br, nno, centroids_accum, new_counts));
            }
            service.invokeAll(jobs);
            for (int k = 0; k < K; ++k) {
                if (new_counts[k] == 0) {
                    new_counts[k] = 1;
                    long[][] rnd = new long[][]{centroids[k]};
                    data.getRandomRows((Object[])rnd);
                    continue;
                }
                for (int d = 0; d < D; ++d) {
                    centroids[k][d] = (long)this.roundDouble(centroids_accum[k][d] / (double)new_counts[k]);
                }
            }
        }
    }

    protected float roundFloat(double value) {
        return (float)value;
    }

    protected double roundDouble(double value) {
        return value;
    }

    protected long roundLong(double value) {
        return Math.round(value);
    }

    protected int roundInt(double value) {
        return (int)Math.round(value);
    }

    @Override
    public LongCentroidsResult cluster(DataSource<long[]> ds) {
        try {
            Result result = this.cluster(ds, this.conf.K);
            result.nn = (LongNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KMeansConfiguration<LongNearestNeighbours, long[]> getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(KMeansConfiguration<LongNearestNeighbours, long[]> conf) {
        this.conf = conf;
    }

    public static LongKMeans createExact(int K) {
        KMeansConfiguration<LongNearestNeighbours, long[]> conf = new KMeansConfiguration<LongNearestNeighbours, long[]>(K, (NearestNeighboursFactory<LongNearestNeighbours, long[]>)new LongNearestNeighboursExact.Factory());
        return new LongKMeans(conf);
    }

    public static LongKMeans createExact(int K, int niters) {
        KMeansConfiguration<LongNearestNeighbours, long[]> conf = new KMeansConfiguration<LongNearestNeighbours, long[]>(K, (NearestNeighboursFactory<LongNearestNeighbours, long[]>)new LongNearestNeighboursExact.Factory(), niters);
        return new LongKMeans(conf);
    }

    public static LongKMeans createKDTreeEnsemble(int K) {
        KMeansConfiguration<LongNearestNeighbours, long[]> conf = new KMeansConfiguration<LongNearestNeighbours, long[]>(K, (NearestNeighboursFactory<LongNearestNeighbours, long[]>)new LongNearestNeighboursKDTree.Factory());
        return new LongKMeans(conf);
    }

    public String toString() {
        return String.format("%s: {K=%d, NN=%s}", this.getClass().getSimpleName(), this.conf.K, this.conf.getNearestNeighbourFactory().getClass().getSimpleName());
    }

    private static class Result
    extends LongCentroidsResult
    implements LongNearestNeighboursProvider {
        protected LongNearestNeighbours nn;

        private Result() {
        }

        @Override
        public HardAssigner<long[], double[], IntDoublePair> defaultHardAssigner() {
            if (this.nn instanceof LongNearestNeighboursExact) {
                return new ExactLongAssigner(this);
            }
            return new KDTreeLongEuclideanAssigner(this);
        }

        public LongNearestNeighbours getNearestNeighbours() {
            return this.nn;
        }
    }

    private static class CentroidAssignmentJob
    implements Callable<Boolean> {
        private final DataSource<long[]> ds;
        private final int startRow;
        private final int stopRow;
        private final LongNearestNeighbours nno;
        private final double[][] centroids_accum;
        private final int[] counts;

        public CentroidAssignmentJob(DataSource<long[]> ds, int startRow, int stopRow, LongNearestNeighbours nno, double[][] centroids_accum, int[] counts) {
            this.ds = ds;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.nno = nno;
            this.centroids_accum = centroids_accum;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                int D = this.nno.numDimensions();
                long[][] points = new long[this.stopRow - this.startRow][D];
                this.ds.getData(this.startRow, this.stopRow, (Object[])points);
                int[] argmins = new int[points.length];
                double[] mins = new double[points.length];
                this.nno.searchNN((Object[])points, argmins, (Object)mins);
                double[][] dArray = this.centroids_accum;
                synchronized (this.centroids_accum) {
                    for (int i = 0; i < points.length; ++i) {
                        int k = argmins[i];
                        for (int d = 0; d < D; ++d) {
                            double[] dArray2 = this.centroids_accum[k];
                            int n = d;
                            dArray2[n] = dArray2[n] + (double)points[i][d];
                        }
                        int n = k;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return true;
            }
        }
    }
}

