/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.LongNearestNeighboursProvider;
import org.openimaj.knn.pq.LongProductQuantiser;
import org.openimaj.ml.clustering.kmeans.LongKMeans;

public final class LongProductQuantiserUtilities {
    private LongProductQuantiserUtilities() {
    }

    public static LongProductQuantiser train(long[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        long[][] tmp = new long[data.length][subDim];
        LongNearestNeighbours[] assigners = new LongNearestNeighbours[numAssigners];
        LongKMeans kmeans = LongKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            LongNearestNeighboursProvider centroids = (LongNearestNeighboursProvider)kmeans.cluster(tmp);
            assigners[i] = centroids.getNearestNeighbours();
        }
        return new LongProductQuantiser(assigners);
    }

    public static LongProductQuantiser train(long[][] data, int numAssigners, int nIter) {
        return LongProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

