/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactShortAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalShortKMeansResult;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.IntFloatPair;

public class HierarchicalShortPathAssigner
implements SoftAssigner<short[], float[]> {
    protected HierarchicalShortKMeansResult result;
    protected Map<CentroidsProvider<short[]>, HardAssigner<short[], float[], IntFloatPair>> assigners;

    public HierarchicalShortPathAssigner(HierarchicalShortKMeansResult result) {
        this.result = result;
        this.assigners = new HashMap<CentroidsProvider<short[]>, HardAssigner<short[], float[], IntFloatPair>>();
    }

    public int[][] assign(short[][] data) {
        int[][] assignments = new int[data.length][this.result.getDepth()];
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalShortKMeansResult.Node node = this.result.getRoot();
            int d = 0;
            while (node != null) {
                int best;
                ExactShortAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactShortAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                assignments[i][d] = best = assigner.assign((short[])data[i]);
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best];
            }
        }
        return assignments;
    }

    @Override
    public int[] assign(short[] data) {
        return this.assign(new short[][]{data})[0];
    }

    public void assignWeighted(short[][] data, int[][] assignments, float[][] weights) {
        int depth = this.result.getDepth();
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalShortKMeansResult.Node node = this.result.getRoot();
            if (assignments[i].length != depth) {
                assignments[i] = new int[depth];
            }
            Arrays.fill((Object[])assignments, (Object)-1);
            if (weights[i].length != depth) {
                weights[i] = new float[depth];
            }
            int d = 0;
            while (node != null) {
                ExactShortAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactShortAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                IntFloatPair best = assigner.assignDistance((short[])data[i]);
                assignments[i][d] = best.first;
                weights[i][d] = best.second;
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best.first];
            }
        }
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(short[] data) {
        int[][] assignments = new int[1][];
        float[][] weights = new float[1][];
        this.assignWeighted(new short[][]{data}, (int[][])assignments, weights);
        return new IndependentPair((Object)assignments[0], (Object)weights[0]);
    }

    @Override
    public int numDimensions() {
        return this.result.numDimensions();
    }

    @Override
    public int size() {
        return this.result.numClusters();
    }
}

