/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.ShortFVComparator;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.knn.ShortNearestNeighbours;
import org.openimaj.knn.ShortNearestNeighboursExact;
import org.openimaj.knn.ShortNearestNeighboursProvider;
import org.openimaj.knn.approximate.ShortNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class ShortKNNAssigner
implements SoftAssigner<short[], float[]> {
    protected ShortNearestNeighbours nn;
    protected int numNeighbours;

    public ShortKNNAssigner(CentroidsProvider<short[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new ShortNearestNeighboursExact((short[][])provider.getCentroids());
        } else {
            ShortNearestNeighbours internal;
            if (provider instanceof ShortNearestNeighboursProvider && (internal = ((ShortNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof ShortNearestNeighboursKDTree) {
                this.nn = (ShortNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new ShortNearestNeighboursKDTree((short[][])provider.getCentroids(), 8, 768);
        }
    }

    public ShortKNNAssigner(short[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new ShortNearestNeighboursExact(data) : new ShortNearestNeighboursKDTree(data, 8, 768);
    }

    public ShortKNNAssigner(CentroidsProvider<short[]> provider, ShortFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new ShortNearestNeighboursExact((short[][])provider.getCentroids(), (ShortFVComparator)comparison);
    }

    public ShortKNNAssigner(short[][] data, ShortFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new ShortNearestNeighboursExact(data, (ShortFVComparator)comparison);
    }

    public int[][] assign(short[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(short[] data) {
        return this.assign(new short[][]{data})[0];
    }

    public void assignWeighted(short[][] data, int[][] assignments, float[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(short[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new short[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    @Override
    public int size() {
        return this.nn.size();
    }
}

