/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearDoubleValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearDoubleValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class DoubleArrayValueAnimator
implements ValueAnimator<double[]> {
    ValueAnimator<Double>[] animators;

    public DoubleArrayValueAnimator(ValueAnimator<Double> ... animators) {
        this.animators = animators;
    }

    public static DoubleArrayValueAnimator makeLinear(int duration, double ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearDoubleValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new DoubleArrayValueAnimator(animators);
    }

    public static DoubleArrayValueAnimator makeLinear(int duration, int count, double start, double finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearDoubleValueAnimator(start, finish, duration);
        }
        return new DoubleArrayValueAnimator(animators);
    }

    public static DoubleArrayValueAnimator makeRandomLinear(int duration, double ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearDoubleValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new DoubleArrayValueAnimator(animators);
    }

    public static DoubleArrayValueAnimator makeRandomLinear(int duration, int count, double start, double finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearDoubleValueAnimator(start, finish, duration);
        }
        return new DoubleArrayValueAnimator(animators);
    }

    @Override
    public double[] nextValue() {
        double[] value = new double[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Double> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Double> animator : this.animators) {
            animator.reset();
        }
    }
}

