/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearIntegerValueAnimator
extends AbstractValueAnimator<Integer>
implements ReversableValueAnimator<Integer> {
    int start;
    int finish;
    int incr;
    int current;

    public LinearIntegerValueAnimator(int start, int finish, int duration) {
        super(start, 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / duration;
    }

    public LinearIntegerValueAnimator(int startWait, int stopWait, int start, int finish, int duration) {
        super(start, startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / duration;
    }

    @Override
    public Integer makeNextValue() {
        this.current += this.incr;
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return this.current;
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0) {
            return true;
        }
        int next = this.current + this.incr;
        if (this.start < this.finish && (double)next - 1.0E-7 > (double)this.finish) {
            return true;
        }
        return this.start > this.finish && (double)next + 1.0E-7 < (double)this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Integer> reverseAnimator() {
        int curr = this.current;
        this.reset();
        this.current = curr;
        this.incr *= -1;
        return this;
    }
}

