/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearLongValueAnimator
extends AbstractValueAnimator<Long>
implements ReversableValueAnimator<Long> {
    long start;
    long finish;
    long incr;
    long current;

    public LinearLongValueAnimator(long start, long finish, int duration) {
        super(start, 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (long)duration;
    }

    public LinearLongValueAnimator(int startWait, int stopWait, long start, long finish, int duration) {
        super(start, startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (long)duration;
    }

    @Override
    public Long makeNextValue() {
        this.current += this.incr;
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return this.current;
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0L) {
            return true;
        }
        long next = this.current + this.incr;
        if (this.start < this.finish && (double)next - 1.0E-7 > (double)this.finish) {
            return true;
        }
        return this.start > this.finish && (double)next + 1.0E-7 < (double)this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Long> reverseAnimator() {
        long curr = this.current;
        this.reset();
        this.current = curr;
        this.incr *= -1L;
        return this;
    }
}

