/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearByteValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearByteValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class ByteArrayValueAnimator
implements ValueAnimator<byte[]> {
    ValueAnimator<Byte>[] animators;

    public ByteArrayValueAnimator(ValueAnimator<Byte> ... animators) {
        this.animators = animators;
    }

    public static ByteArrayValueAnimator makeLinear(int duration, byte ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearByteValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new ByteArrayValueAnimator(animators);
    }

    public static ByteArrayValueAnimator makeLinear(int duration, int count, byte start, byte finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearByteValueAnimator(start, finish, duration);
        }
        return new ByteArrayValueAnimator(animators);
    }

    public static ByteArrayValueAnimator makeRandomLinear(int duration, byte ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearByteValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new ByteArrayValueAnimator(animators);
    }

    public static ByteArrayValueAnimator makeRandomLinear(int duration, int count, byte start, byte finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearByteValueAnimator(start, finish, duration);
        }
        return new ByteArrayValueAnimator(animators);
    }

    @Override
    public byte[] nextValue() {
        byte[] value = new byte[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Byte> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Byte> animator : this.animators) {
            animator.reset();
        }
    }
}

