/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearIntegerValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearIntegerValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class IntegerArrayValueAnimator
implements ValueAnimator<int[]> {
    ValueAnimator<Integer>[] animators;

    public IntegerArrayValueAnimator(ValueAnimator<Integer> ... animators) {
        this.animators = animators;
    }

    public static IntegerArrayValueAnimator makeLinear(int duration, int ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearIntegerValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new IntegerArrayValueAnimator(animators);
    }

    public static IntegerArrayValueAnimator makeLinear(int duration, int count, int start, int finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearIntegerValueAnimator(start, finish, duration);
        }
        return new IntegerArrayValueAnimator(animators);
    }

    public static IntegerArrayValueAnimator makeRandomLinear(int duration, int ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearIntegerValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new IntegerArrayValueAnimator(animators);
    }

    public static IntegerArrayValueAnimator makeRandomLinear(int duration, int count, int start, int finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearIntegerValueAnimator(start, finish, duration);
        }
        return new IntegerArrayValueAnimator(animators);
    }

    @Override
    public int[] nextValue() {
        int[] value = new int[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Integer> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Integer> animator : this.animators) {
            animator.reset();
        }
    }
}

