/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearShortValueAnimator
extends AbstractValueAnimator<Short>
implements ReversableValueAnimator<Short> {
    short start;
    short finish;
    short incr;
    short current;

    public LinearShortValueAnimator(short start, short finish, int duration) {
        super(start, 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (short)((finish - start) / (short)duration);
    }

    public LinearShortValueAnimator(int startWait, int stopWait, short start, short finish, int duration) {
        super(start, startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (short)((finish - start) / (short)duration);
    }

    @Override
    public Short makeNextValue() {
        this.current = (short)(this.current + this.incr);
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return this.current;
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0) {
            return true;
        }
        short next = (short)(this.current + this.incr);
        if (this.start < this.finish && (double)next - 1.0E-7 > (double)this.finish) {
            return true;
        }
        return this.start > this.finish && (double)next + 1.0E-7 < (double)this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Short> reverseAnimator() {
        short curr = this.current;
        this.reset();
        this.current = curr;
        this.incr = (short)(this.incr * -1);
        return this;
    }
}

