/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.tracking.clm.MultiTracker;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Jason M. Saragih", "Simon Lucey", "Jeffrey F. Cohn"}, title="Face alignment through subspace constrained mean-shifts", year="2009", booktitle="IEEE 12th International Conference on Computer Vision, ICCV 2009, Kyoto, Japan, September 27 - October 4, 2009", pages={"1034", "1041"}, publisher="IEEE", customData={"doi", "http://dx.doi.org/10.1109/ICCV.2009.5459377", "researchr", "http://researchr.org/publication/SaragihLC09", "cites", "0", "citedby", "0"})
public class CLMDetectedFace
extends DetectedFace {
    private Matrix shape;
    private Matrix poseParameters;
    private Matrix shapeParameters;
    private Matrix visibility;

    protected CLMDetectedFace() {
    }

    public CLMDetectedFace(MultiTracker.TrackedFace face, FImage image) {
        this(face.redetectedBounds, face.shape.copy(), face.clm._pglobl.copy(), face.clm._plocal.copy(), face.clm._visi[face.clm.getViewIdx()].copy(), image);
    }

    public CLMDetectedFace(Rectangle bounds, Matrix shape, Matrix poseParameters, Matrix shapeParameters, Matrix visibility, FImage fullImage) {
        super(bounds, (FImage)fullImage.extractROI(bounds), 1.0f);
        this.poseParameters = poseParameters;
        this.shapeParameters = shapeParameters;
        this.visibility = visibility;
        this.shape = shape;
        int n = shape.getRowDimension() / 2;
        double[][] shapeData = shape.getArray();
        for (int i = 0; i < n; ++i) {
            double[] dArray = shapeData[i];
            dArray[0] = dArray[0] - (double)bounds.x;
            double[] dArray2 = shapeData[i + n];
            dArray2[0] = dArray2[0] - (double)bounds.y;
        }
    }

    public static List<CLMDetectedFace> convert(List<MultiTracker.TrackedFace> faces, MBFImage image) {
        FImage fimage = image.flatten();
        return CLMDetectedFace.convert(faces, fimage);
    }

    public static List<CLMDetectedFace> convert(List<MultiTracker.TrackedFace> faces, FImage image) {
        ArrayList<CLMDetectedFace> cvt = new ArrayList<CLMDetectedFace>();
        for (MultiTracker.TrackedFace f : faces) {
            cvt.add(new CLMDetectedFace(f, image));
        }
        return cvt;
    }

    public MultiTracker.TrackedFace convert() {
        MultiTracker.TrackerVars tv = new MultiTracker.TrackerVars();
        tv.clm._pglobl = this.poseParameters.copy();
        tv.clm._plocal = this.shapeParameters.copy();
        tv.shape = this.shape.copy();
        tv.clm._visi[tv.clm.getViewIdx()] = this.visibility.copy();
        return new MultiTracker.TrackedFace(this.bounds, tv);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        IOUtils.write((Object)this.getShape(), (DataOutput)out);
        IOUtils.write((Object)this.poseParameters, (DataOutput)out);
        IOUtils.write((Object)this.shapeParameters, (DataOutput)out);
    }

    @Override
    public byte[] binaryHeader() {
        return "DF".getBytes();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.shape = (Matrix)IOUtils.read((DataInput)in);
        this.poseParameters = (Matrix)IOUtils.read((DataInput)in);
        this.shapeParameters = (Matrix)IOUtils.read((DataInput)in);
    }

    public double getScale() {
        return this.poseParameters.get(0, 0);
    }

    public double getPitch() {
        return this.poseParameters.get(1, 0);
    }

    public double getYaw() {
        return this.poseParameters.get(2, 0);
    }

    public double getRoll() {
        return this.poseParameters.get(3, 0);
    }

    public double getTranslationX() {
        return this.poseParameters.get(4, 0);
    }

    public double getTranslationY() {
        return this.poseParameters.get(5, 0);
    }

    public DoubleFV getPoseParameters() {
        return new DoubleFV(new double[]{this.getPitch(), this.getYaw(), this.getRoll()});
    }

    public DoubleFV getShapeParameters() {
        int len = this.shapeParameters.getRowDimension();
        double[] vector = new double[len];
        for (int i = 0; i < len; ++i) {
            vector[i] = this.shapeParameters.get(i, 0);
        }
        return new DoubleFV(vector);
    }

    public DoubleFV getPoseShapeParameters() {
        int len = this.shapeParameters.getRowDimension();
        double[] vector = new double[len + 3];
        vector[0] = this.getPitch();
        vector[1] = this.getYaw();
        vector[2] = this.getRoll();
        for (int i = 3; i < len + 3; ++i) {
            vector[i] = this.shapeParameters.get(i, 0);
        }
        return new DoubleFV(vector);
    }

    public Matrix getShapeMatrix() {
        return this.shape;
    }

    public Matrix getVisibility() {
        return this.visibility;
    }
}

