/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import Jama.Matrix;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.transform.FProjectionProcessor;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class EllipticalDetectedFace
extends DetectedFace {
    Ellipse ellipse;

    public EllipticalDetectedFace(Ellipse ellipse, FImage image, float confidence) {
        this.ellipse = ellipse;
        this.bounds = ellipse.calculateRegularBoundingBox();
        this.confidence = confidence;
        if (image != null) {
            this.facePatch = this.extractPatch(image, ellipse);
        }
    }

    private FImage extractPatch(FImage image, Ellipse ellipse) {
        float x = ellipse.calculateCentroid().getX();
        float y = ellipse.calculateCentroid().getY();
        double major = ellipse.getMajor();
        double minor = ellipse.getMinor();
        Matrix rot = TransformUtilities.rotationMatrixAboutPoint((double)(-ellipse.getRotation() + 1.5707963267948966), (float)x, (float)y);
        Matrix translate = TransformUtilities.translateMatrix((double)(-((double)x - minor)), (double)(-((double)y - major)));
        Matrix tf = translate.times(rot);
        FProjectionProcessor pp = new FProjectionProcessor();
        pp.setMatrix(tf);
        pp.accumulate((Image)image);
        return (FImage)pp.performProjection(0, (int)(2.0 * minor), 0, (int)(2.0 * major));
    }

    @Override
    public Shape getShape() {
        return this.ellipse;
    }
}

