/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.objectdetection.filtering.DetectionFilter;
import org.openimaj.image.objectdetection.filtering.OpenCVGrouping;
import org.openimaj.image.objectdetection.haar.Detector;
import org.openimaj.image.objectdetection.haar.OCVHaarLoader;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.image.processing.algorithm.EqualisationProcessor;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.hash.HashCodeUtil;
import org.openimaj.util.pair.ObjectIntPair;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public class HaarCascadeDetector
implements FaceDetector<DetectedFace, FImage> {
    protected Detector detector;
    protected DetectionFilter<Rectangle, ObjectIntPair<Rectangle>> groupingFilter;
    protected boolean histogramEqualize = false;

    public HaarCascadeDetector(String cas) {
        try {
            this.setCascade(cas);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.groupingFilter = new OpenCVGrouping();
    }

    public HaarCascadeDetector() {
        this(BuiltInCascade.frontalface_default.classFile());
    }

    public HaarCascadeDetector(int minSize) {
        this();
        this.detector.setMinimumDetectionSize(minSize);
    }

    public HaarCascadeDetector(String cas, int minSize) {
        this(cas);
        this.detector.setMinimumDetectionSize(minSize);
    }

    public int getMinSize() {
        return this.detector.getMinimumDetectionSize();
    }

    public void setMinSize(int size) {
        this.detector.setMinimumDetectionSize(size);
    }

    public int getMaxSize() {
        return this.detector.getMaximumDetectionSize();
    }

    public void setMaxSize(int size) {
        this.detector.setMaximumDetectionSize(size);
    }

    public DetectionFilter<Rectangle, ObjectIntPair<Rectangle>> getGroupingFilter() {
        return this.groupingFilter;
    }

    public void setGroupingFilter(DetectionFilter<Rectangle, ObjectIntPair<Rectangle>> grouping) {
        this.groupingFilter = grouping;
    }

    @Override
    public List<DetectedFace> detectFaces(FImage image) {
        if (this.histogramEqualize) {
            image.processInplace((SinglebandImageProcessor)new EqualisationProcessor());
        }
        List rects = this.detector.detect(image);
        List filteredRects = this.groupingFilter.apply(rects);
        ArrayList<DetectedFace> results = new ArrayList<DetectedFace>();
        for (ObjectIntPair r : filteredRects) {
            results.add(new DetectedFace((Rectangle)r.first, (FImage)image.extractROI((Rectangle)r.first), r.second));
        }
        return results;
    }

    public double getScaleFactor() {
        return this.detector.getScaleFactor();
    }

    public void setCascade(String cascadeResource) throws Exception {
        InputStream in = null;
        try {
            in = OCVHaarLoader.class.getResourceAsStream(cascadeResource);
            if (in == null) {
                in = new FileInputStream(new File(cascadeResource));
            }
            StageTreeClassifier cascade = OCVHaarLoader.read((InputStream)in);
            this.detector = this.detector == null ? new Detector(cascade) : new Detector(cascade, this.detector.getScaleFactor());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setScale(float scaleFactor) {
        this.detector.setScaleFactor(scaleFactor);
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this);
    }

    public static HaarCascadeDetector read(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        return (HaarCascadeDetector)ois.readObject();
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = HashCodeUtil.hash((int)hashCode, (int)this.detector.getMinimumDetectionSize());
        hashCode = HashCodeUtil.hash((int)hashCode, (float)this.detector.getScaleFactor());
        hashCode = HashCodeUtil.hash((int)hashCode, (Object)this.detector.getClassifier().getName());
        hashCode = HashCodeUtil.hash((int)hashCode, this.groupingFilter);
        hashCode = HashCodeUtil.hash((int)hashCode, (boolean)this.histogramEqualize);
        return hashCode;
    }

    public void readBinary(DataInput in) throws IOException {
        this.detector = (Detector)IOUtils.read((DataInput)in);
        this.groupingFilter = (DetectionFilter)IOUtils.read((DataInput)in);
        this.histogramEqualize = in.readBoolean();
    }

    public byte[] binaryHeader() {
        return "HAAR".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)this.detector, (DataOutput)out);
        IOUtils.write(this.groupingFilter, (DataOutput)out);
        out.writeBoolean(this.histogramEqualize);
    }

    public String toString() {
        return "HaarCascadeDetector[cascade=" + this.detector.getClassifier().getName() + "]";
    }

    public StageTreeClassifier getCascade() {
        return this.detector.getClassifier();
    }

    public Detector getDetector() {
        return this.detector;
    }

    public static enum BuiltInCascade {
        eye("haarcascade_eye.xml"),
        eye_tree_eyeglasses("haarcascade_eye_tree_eyeglasses.xml"),
        frontalface_alt("haarcascade_frontalface_alt.xml"),
        frontalface_alt2("haarcascade_frontalface_alt2.xml"),
        frontalface_alt_tree("haarcascade_frontalface_alt_tree.xml"),
        frontalface_default("haarcascade_frontalface_default.xml"),
        fullbody("haarcascade_fullbody.xml"),
        lefteye_2splits("haarcascade_lefteye_2splits.xml"),
        lowerbody("haarcascade_lowerbody.xml"),
        mcs_eyepair_big("haarcascade_mcs_eyepair_big.xml"),
        mcs_eyepair_small("haarcascade_mcs_eyepair_small.xml"),
        mcs_lefteye("haarcascade_mcs_lefteye.xml"),
        mcs_mouth("haarcascade_mcs_mouth.xml"),
        mcs_nose("haarcascade_mcs_nose.xml"),
        mcs_righteye("haarcascade_mcs_righteye.xml"),
        mcs_upperbody("haarcascade_mcs_upperbody.xml"),
        profileface("haarcascade_profileface.xml"),
        righteye_2splits("haarcascade_righteye_2splits.xml"),
        upperbody("haarcascade_upperbody.xml");

        private String classFile;

        private BuiltInCascade(String classFile) {
            this.classFile = classFile;
        }

        public String classFile() {
            return this.classFile;
        }

        public HaarCascadeDetector load() {
            try {
                return new HaarCascadeDetector(this.classFile);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

