/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.benchmarking;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.EllipticalDetectedFace;
import org.openimaj.image.processing.face.detection.benchmarking.FDDBRecord;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;

public class FDDBDataset
extends ListBackedDataset<FDDBRecord> {
    File imageBase;
    final String imageExtension = ".jpg";

    public FDDBDataset(File fddbGroundTruth, File imageBase, boolean loadImages) throws IOException {
        this.data = new ArrayList();
        this.imageBase = imageBase;
        this.read(fddbGroundTruth, loadImages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(File fddbGroundTruth, boolean loadImages) throws IOException {
        BufferedReader br = null;
        try {
            String imageName;
            br = new BufferedReader(new FileReader(fddbGroundTruth));
            while ((imageName = br.readLine()) != null) {
                Record r = new Record();
                r.imageName = imageName;
                r.groundTruth = new ArrayList();
                int nDet = Integer.parseInt(br.readLine());
                for (int i = 0; i < nDet; ++i) {
                    String[] parts = br.readLine().split("\\s+");
                    if (parts.length != 6) {
                        throw new IOException("bad format");
                    }
                    double major = Double.parseDouble(parts[0]);
                    double minor = Double.parseDouble(parts[1]);
                    double theta = Double.parseDouble(parts[2]);
                    double x = Double.parseDouble(parts[3]);
                    double y = Double.parseDouble(parts[4]);
                    float confidence = Float.parseFloat(parts[5]);
                    Ellipse ellipse = EllipseUtilities.ellipseFromEquation((double)x, (double)y, (double)major, (double)minor, (double)theta);
                    EllipticalDetectedFace detection = !loadImages ? new EllipticalDetectedFace(ellipse, null, confidence) : new EllipticalDetectedFace(ellipse, r.getFImage(), confidence);
                    r.groundTruth.add(detection);
                }
                this.data.add(r);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    class Record
    implements FDDBRecord {
        String imageName;
        private List<DetectedFace> groundTruth;

        Record() {
        }

        @Override
        public String getImageName() {
            return this.imageName;
        }

        @Override
        public FImage getFImage() {
            try {
                return ImageUtilities.readF((File)new File(FDDBDataset.this.imageBase, this.imageName + ".jpg"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public MBFImage getMBFImage() {
            try {
                return ImageUtilities.readMBF((File)new File(FDDBDataset.this.imageBase, this.imageName + ".jpg"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<? extends DetectedFace> getGroundTruth() {
            return this.groundTruth;
        }
    }
}

