/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.keypoints;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.SimplePyramid;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.combiner.AccumulatingImageCombiner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypointExtractor;
import org.openimaj.image.processing.face.detection.keypoints.KEDetectedFace;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.util.hash.HashCodeUtil;

@Reference(type=ReferenceType.Inproceedings, author={"Mark Everingham", "Josef Sivic", "Andrew Zisserman"}, title="Hello! My name is... Buffy - Automatic naming of characters in TV video", year="2006", booktitle="In BMVC")
public class FKEFaceDetector
implements FaceDetector<KEDetectedFace, FImage> {
    protected FaceDetector<? extends DetectedFace, FImage> faceDetector;
    protected FacialKeypointExtractor facialKeypointExtractor = new FacialKeypointExtractor();
    private float patchScale = 1.0f;

    public FKEFaceDetector() {
        this(new HaarCascadeDetector(80));
    }

    public FKEFaceDetector(int size) {
        this(new HaarCascadeDetector(size));
    }

    public FKEFaceDetector(float patchScale) {
        this(new HaarCascadeDetector(80), patchScale);
    }

    public FKEFaceDetector(int size, float patchScale) {
        this(new HaarCascadeDetector(size), patchScale);
    }

    public FKEFaceDetector(FaceDetector<? extends DetectedFace, FImage> detector) {
        this.faceDetector = detector;
    }

    public FKEFaceDetector(FaceDetector<? extends DetectedFace, FImage> detector, float patchScale) {
        this.faceDetector = detector;
        this.patchScale = patchScale;
    }

    public static FImage pyramidResize(FImage image, Matrix transform) {
        SingularValueDecomposition svd = transform.getMatrix(0, 1, 0, 1).svd();
        double[] sv = svd.getSingularValues();
        double scale = (sv[0] + sv[1]) / 2.0;
        int lev = (int)(Math.max(Math.floor(Math.log(scale) / Math.log(1.5)), 0.0) + 1.0);
        double pyramidScale = Math.pow(1.5, lev - 1);
        Matrix scaleMatrix = TransformUtilities.scaleMatrix((double)(1.0 / pyramidScale), (double)(1.0 / pyramidScale));
        Matrix newTransform = scaleMatrix.times(transform);
        transform.setMatrix(0, 2, 0, 2, newTransform);
        return (FImage)image.process((ImageProcessor)new SimplePyramid(1.5f, lev));
    }

    public static FImage extractPatch(FImage image, Matrix transform, int size, int border) {
        ProjectionProcessor pp = new ProjectionProcessor();
        pp.setMatrix(transform.inverse());
        image.accumulateWith((AccumulatingImageCombiner)pp);
        return (FImage)pp.performProjection(border, size - border, border, size - border, (Object)RGBColour.BLACK[0]);
    }

    @Override
    public List<KEDetectedFace> detectFaces(FImage image) {
        List<? extends DetectedFace> faces = this.faceDetector.detectFaces(image);
        ArrayList<KEDetectedFace> descriptors = new ArrayList<KEDetectedFace>(faces.size());
        for (DetectedFace detectedFace : faces) {
            int canonicalSize = this.facialKeypointExtractor.getCanonicalImageDimension();
            Rectangle r = detectedFace.getBounds();
            float scale = r.width / 2.0f / (float)(canonicalSize / 2 - this.facialKeypointExtractor.model.border);
            float tx = r.x + r.width / 2.0f - scale * (float)canonicalSize / 2.0f;
            float ty = r.y + r.height / 2.0f - scale * (float)canonicalSize / 2.0f;
            Matrix T0 = new Matrix((double[][])new double[][]{{scale, 0.0, tx}, {0.0, scale, ty}, {0.0, 0.0, 1.0}});
            Matrix T = (Matrix)T0.clone();
            FImage subsampled = FKEFaceDetector.pyramidResize(image, T);
            FImage smallpatch = FKEFaceDetector.extractPatch(subsampled, T, canonicalSize, 0);
            FacialKeypoint[] kpts = this.facialKeypointExtractor.extractFacialKeypoints(smallpatch);
            tx = r.width / 2.0f - scale * (float)canonicalSize / 2.0f;
            ty = r.height / 2.0f - scale * (float)canonicalSize / 2.0f;
            Matrix T1 = new Matrix((double[][])new double[][]{{scale, 0.0, tx}, {0.0, scale, ty}, {0.0, 0.0, 1.0}});
            FacialKeypoint.updateImagePosition(kpts, T1);
            FacialKeypoint eyeLL = FacialKeypoint.getKeypoint(kpts, FacialKeypoint.FacialKeypointType.EYE_LEFT_LEFT);
            FacialKeypoint eyeRR = FacialKeypoint.getKeypoint(kpts, FacialKeypoint.FacialKeypointType.EYE_RIGHT_RIGHT);
            FacialKeypoint eyeLR = FacialKeypoint.getKeypoint(kpts, FacialKeypoint.FacialKeypointType.EYE_LEFT_RIGHT);
            FacialKeypoint eyeRL = FacialKeypoint.getKeypoint(kpts, FacialKeypoint.FacialKeypointType.EYE_RIGHT_LEFT);
            float eyeSpace = 0.5f * (eyeRR.position.x + eyeRL.position.x) - 0.5f * (eyeLR.position.x + eyeLL.position.x);
            float deltaX = 0.5f * (eyeLR.position.x + eyeLL.position.x) - eyeSpace;
            r.x += deltaX;
            r.width = eyeSpace * 3.0f;
            float eyeVavg = 0.5f * (0.5f * (eyeRR.position.y + eyeRL.position.y) + 0.5f * (eyeLR.position.y + eyeLL.position.y));
            r.height = 1.28f * r.width;
            float deltaY = eyeVavg - 0.4f * r.height;
            r.y += deltaY;
            float dx = r.x;
            float dy = r.y;
            r.scaleCentroid(this.patchScale);
            FacialKeypoint.updateImagePosition(kpts, TransformUtilities.translateMatrix((double)(-deltaX + (dx -= r.x)), (double)(-deltaY + (dy -= r.y))));
            KEDetectedFace kedf = new KEDetectedFace(r, (FImage)image.extractROI(r), kpts, detectedFace.getConfidence());
            descriptors.add(kedf);
        }
        return descriptors;
    }

    public int hashCode() {
        int hashCode = 23;
        HashCodeUtil.hash((int)23, this.faceDetector);
        HashCodeUtil.hash((int)23, (Object)this.facialKeypointExtractor);
        HashCodeUtil.hash((int)23, (float)this.patchScale);
        return 23;
    }

    public void readBinary(DataInput in) throws IOException {
        this.faceDetector = (FaceDetector)IOUtils.newInstance((String)in.readUTF());
        this.faceDetector.readBinary(in);
        this.patchScale = in.readFloat();
    }

    public byte[] binaryHeader() {
        return "FKED".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(this.faceDetector.getClass().getName());
        this.faceDetector.writeBinary(out);
        out.writeFloat(this.patchScale);
    }

    public String toString() {
        return String.format("FKEFaceDetector[innerDetector=%s]", this.faceDetector);
    }
}

