/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.similarity;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.image.Image;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.image.processing.face.feature.comparison.FacialFeatureComparator;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.matrix.similarity.SimilarityMatrix;
import org.openimaj.math.matrix.similarity.processor.InvertData;
import org.openimaj.math.matrix.similarity.processor.SimilarityMatrixProcessor;

public class FaceSimilarityEngine<D extends DetectedFace, F extends FacialFeature, I extends Image<?, I>> {
    private FaceDetector<D, I> detector;
    private FacialFeatureExtractor<F, D> extractor;
    private FacialFeatureComparator<F> comparator;
    private Map<String, Rectangle> boundingBoxes;
    private Map<String, F> featureCache;
    private Map<String, List<D>> detectedFaceCache;
    private LinkedHashMap<String, Map<String, Double>> similarityMatrix;
    private List<D> queryfaces;
    private List<D> testfaces;
    private String queryId;
    private String testId;
    private boolean cache;

    public FaceSimilarityEngine(FaceDetector<D, I> detector, FacialFeatureExtractor<F, D> extractor, FacialFeatureComparator<F> comparator) {
        this.detector = detector;
        this.extractor = extractor;
        this.comparator = comparator;
        this.similarityMatrix = new LinkedHashMap();
        this.boundingBoxes = new HashMap<String, Rectangle>();
        this.featureCache = new HashMap<String, F>();
        this.detectedFaceCache = new HashMap<String, List<D>>();
    }

    public FaceDetector<D, I> detector() {
        return this.detector;
    }

    public FacialFeatureExtractor<F, D> extractor() {
        return this.extractor;
    }

    public FacialFeatureComparator<F> comparator() {
        return this.comparator;
    }

    public static <D extends DetectedFace, F extends FacialFeature, I extends Image<?, I>> FaceSimilarityEngine<D, F, I> create(FaceDetector<D, I> detector, FacialFeatureExtractor<F, D> extractor, FacialFeatureComparator<F> comparator) {
        return new FaceSimilarityEngine<D, F, I>(detector, extractor, comparator);
    }

    public void setQuery(I queryImage, String queryId) {
        this.queryfaces = this.getDetectedFaces(queryId, queryImage);
        this.queryId = queryId;
        this.updateBoundingBox(this.queryfaces, queryId);
    }

    private List<D> getDetectedFaces(String faceId, I faceImage) {
        List<D> toRet = null;
        if (!this.cache) {
            toRet = this.detector.detectFaces(faceImage);
        } else {
            toRet = this.detectedFaceCache.get(faceId);
            if (toRet == null) {
                toRet = this.detector.detectFaces(faceImage);
                this.detectedFaceCache.put(faceId, toRet);
            }
        }
        return toRet;
    }

    private void updateBoundingBox(List<D> faces, String imageId) {
        if (this.boundingBoxes != null) {
            for (int ff = 0; ff < faces.size(); ++ff) {
                if (this.boundingBoxes.get(imageId + ":" + ff) != null) continue;
                this.boundingBoxes.put(imageId + ":" + ff, ((DetectedFace)faces.get(ff)).getBounds());
            }
        }
    }

    public void setTest(I testImage, String testId) {
        this.testId = testId;
        this.testfaces = this.getDetectedFaces(testId, testImage);
        this.updateBoundingBox(this.testfaces, testId);
    }

    public void setQueryTest() {
        this.testfaces = this.queryfaces;
        this.testId = this.queryId;
    }

    public void performTest() {
        for (int ii = 0; ii < this.queryfaces.size(); ++ii) {
            String face1id = this.queryId + ":" + ii;
            DetectedFace f1f = (DetectedFace)this.queryfaces.get(ii);
            F f1fv = this.getFeature(face1id, f1f);
            for (int jj = 0; jj < this.testfaces.size(); ++jj) {
                double d = 0.0;
                String face2id = null;
                if (this.queryfaces == this.testfaces && ii == jj) {
                    d = 0.0;
                    face2id = face1id;
                } else {
                    DetectedFace f2f = (DetectedFace)this.testfaces.get(jj);
                    face2id = this.testId + ":" + jj;
                    F f2fv = this.getFeature(face2id, f2f);
                    d = this.comparator.compare(f1fv, f2fv);
                }
                Map<String, Double> mm = this.similarityMatrix.get(face1id);
                if (mm == null) {
                    mm = new HashMap<String, Double>();
                    this.similarityMatrix.put(face1id, mm);
                }
                mm.put(face2id, d);
            }
        }
    }

    private F getFeature(String id, D face) {
        FacialFeature toRet = null;
        if (!this.cache) {
            toRet = (FacialFeature)this.extractor.extractFeature(face);
        } else {
            String combinedID = String.format("%s:%b", id);
            toRet = (FacialFeature)this.featureCache.get(combinedID);
            if (toRet == null) {
                toRet = (FacialFeature)this.extractor.extractFeature(face);
                this.featureCache.put(combinedID, toRet);
            }
        }
        return (F)toRet;
    }

    public Map<String, Map<String, Double>> getSimilarityDictionary() {
        return this.similarityMatrix;
    }

    public SimilarityMatrix getSimilarityMatrix(boolean invertIfRequired) {
        Set<String> keys = this.similarityMatrix.keySet();
        String[] indexArr = keys.toArray(new String[keys.size()]);
        SimilarityMatrix simMatrix = new SimilarityMatrix(indexArr);
        for (int i = 0; i < indexArr.length; ++i) {
            String x = indexArr[i];
            for (int j = 0; j < indexArr.length; ++j) {
                String y = indexArr[j];
                simMatrix.set(i, j, this.similarityMatrix.get(x).get(y).doubleValue());
            }
        }
        if (this.comparator.isDistance() && invertIfRequired) {
            simMatrix.processInplace((SimilarityMatrixProcessor)new InvertData());
        }
        return simMatrix;
    }

    public Map<String, Rectangle> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

