/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.tracking.clm;

import Jama.Matrix;
import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.face.tracking.clm.MultiTracker;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.shape.Triangle;

public class CLMFaceTracker {
    public MultiTracker model = null;
    public int[][] triangles = null;
    public int[][] connections = null;
    public float scale = 1.0f;
    public boolean fcheck = false;
    public int fpd = -1;
    public int[] wSize1 = new int[]{7};
    public int[] wSize2 = new int[]{11, 9, 7};
    public int nIter = 5;
    public double clamp = 3.0;
    public double fTol = 0.01;
    private boolean failed = true;
    public float searchAreaSize = 1.4f;
    private Float[] connectionColour = RGBColour.WHITE;
    private Float[] pointColour = RGBColour.GREEN;
    private Float[] meshColour = RGBColour.BLACK;
    private Float[] boundingBoxColour = RGBColour.RED;
    private Float[] searchAreaColour = RGBColour.YELLOW;

    public CLMFaceTracker() {
        this.model = new MultiTracker(MultiTracker.load(Tracker.class.getResourceAsStream("face2.tracker")));
        this.triangles = IO.loadTri((InputStream)Tracker.class.getResourceAsStream("face.tri"));
        this.connections = IO.loadCon((InputStream)Tracker.class.getResourceAsStream("face.con"));
    }

    public void track(MBFImage frame) {
        FImage im = frame.flatten();
        this.track(im);
    }

    public void track(FImage im) {
        int[] wSize;
        if (this.scale != 1.0f) {
            im = this.scale == 0.5f ? ResizeProcessor.halfSize((FImage)im) : ResizeProcessor.resample((FImage)im, (int)((int)(this.scale * (float)im.width)), (int)((int)(this.scale * (float)im.height)));
        }
        if (this.model.track(im, wSize = this.failed ? this.wSize2 : this.wSize1, this.fpd, this.nIter, this.clamp, this.fTol, this.fcheck, this.searchAreaSize) == 0) {
            this.failed = false;
        } else {
            this.model.frameReset();
            this.failed = true;
        }
    }

    public void reset() {
        this.model.frameReset();
    }

    public void drawModel(MBFImage image, boolean drawTriangles, boolean drawConnections, boolean drawPoints, boolean drawSearchArea, boolean drawBounds) {
        for (int fc = 0; fc < this.model.trackedFaces.size(); ++fc) {
            MultiTracker.TrackedFace f = this.model.trackedFaces.get(fc);
            if (drawSearchArea) {
                Rectangle r = f.lastMatchBounds.clone();
                r.scaleCentroid(this.searchAreaSize);
                image.createRenderer().drawShape((Shape)r, (Object)RGBColour.YELLOW);
            }
            CLMFaceTracker.drawFaceModel(image, f, drawTriangles, drawConnections, drawPoints, drawSearchArea, drawBounds, this.triangles, this.connections, this.scale, this.boundingBoxColour, this.meshColour, this.connectionColour, this.pointColour);
        }
    }

    public static void drawFaceModel(MBFImage image, MultiTracker.TrackedFace f, boolean drawTriangles, boolean drawConnections, boolean drawPoints, boolean drawSearchArea, boolean drawBounds, int[][] triangles, int[][] connections, float scale, Float[] boundingBoxColour, Float[] meshColour, Float[] connectionColour, Float[] pointColour) {
        int i;
        int n = f.shape.getRowDimension() / 2;
        Matrix visi = f.clm._visi[f.clm.getViewIdx()];
        if (drawBounds && f.lastMatchBounds != null) {
            image.createRenderer().drawShape((Shape)f.lastMatchBounds, (Object)boundingBoxColour);
        }
        if (drawTriangles) {
            for (i = 0; i < triangles.length; ++i) {
                if (visi.get(triangles[i][0], 0) == 0.0 || visi.get(triangles[i][1], 0) == 0.0 || visi.get(triangles[i][2], 0) == 0.0) continue;
                Triangle t = new Triangle((Point2d)new Point2dImpl((float)f.shape.get(triangles[i][0], 0) / scale, (float)f.shape.get(triangles[i][0] + n, 0) / scale), (Point2d)new Point2dImpl((float)f.shape.get(triangles[i][1], 0) / scale, (float)f.shape.get(triangles[i][1] + n, 0) / scale), (Point2d)new Point2dImpl((float)f.shape.get(triangles[i][2], 0) / scale, (float)f.shape.get(triangles[i][2] + n, 0) / scale));
                image.drawShape((Shape)t, (Object)meshColour);
            }
        }
        if (drawConnections) {
            for (i = 0; i < connections[0].length; ++i) {
                if (visi.get(connections[0][i], 0) == 0.0 || visi.get(connections[1][i], 0) == 0.0) continue;
                image.drawLine((Point2d)new Point2dImpl((float)f.shape.get(connections[0][i], 0) / scale, (float)f.shape.get(connections[0][i] + n, 0) / scale), (Point2d)new Point2dImpl((float)f.shape.get(connections[1][i], 0) / scale, (float)f.shape.get(connections[1][i] + n, 0) / scale), (Object)connectionColour);
            }
        }
        if (drawPoints) {
            for (i = 0; i < n; ++i) {
                if (visi.get(i, 0) == 0.0) continue;
                image.drawPoint((Point2d)new Point2dImpl((float)f.shape.get(i, 0) / scale, (float)f.shape.get(i + n, 0) / scale), (Object)pointColour, 2);
            }
        }
    }

    public int[][] getReferenceTriangles() {
        return this.triangles;
    }

    public int[][] getReferenceConnections() {
        return this.connections;
    }

    public MultiTracker getModelTracker() {
        return this.model;
    }

    public MultiTracker.TrackerVars getInitialVars() {
        return this.model.getInitialVars();
    }

    public void initialiseFaceModel(MultiTracker.TrackedFace face) {
        this.model.initShape(face.redetectedBounds, face.shape, face.referenceShape);
    }

    public float getSearchAreaSize() {
        return this.searchAreaSize;
    }

    public void setSearchAreaSize(float searchAreaSize) {
        this.searchAreaSize = searchAreaSize;
    }

    public Float[] getConnectionColour() {
        return this.connectionColour;
    }

    public void setConnectionColour(Float[] connectionColour) {
        this.connectionColour = connectionColour;
    }

    public Float[] getPointColour() {
        return this.pointColour;
    }

    public void setPointColour(Float[] pointColour) {
        this.pointColour = pointColour;
    }

    public Float[] getMeshColour() {
        return this.meshColour;
    }

    public void setMeshColour(Float[] meshColour) {
        this.meshColour = meshColour;
    }

    public Float[] getBoundingBoxColour() {
        return this.boundingBoxColour;
    }

    public void setBoundingBoxColour(Float[] boundingBoxColour) {
        this.boundingBoxColour = boundingBoxColour;
    }

    public Float[] getSearchAreaColour() {
        return this.searchAreaColour;
    }

    public void setSearchAreaColour(Float[] searchAreaColour) {
        this.searchAreaColour = searchAreaColour;
    }

    public List<MultiTracker.TrackedFace> getTrackedFaces() {
        return this.model.trackedFaces;
    }

    public List<Triangle> getTriangles(MultiTracker.TrackedFace face) {
        return CLMFaceTracker.getTriangles(face.shape, face.clm._visi[face.clm.getViewIdx()], this.triangles);
    }

    public static List<Triangle> getTriangles(Matrix shape, Matrix visi, int[][] triangles) {
        int n = shape.getRowDimension() / 2;
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (int i = 0; i < triangles.length; ++i) {
            if (visi != null && (visi.get(triangles[i][0], 0) == 0.0 || visi.get(triangles[i][1], 0) == 0.0 || visi.get(triangles[i][2], 0) == 0.0)) {
                tris.add(null);
                continue;
            }
            Triangle t = new Triangle((Point2d)new Point2dImpl((float)shape.get(triangles[i][0], 0), (float)shape.get(triangles[i][0] + n, 0)), (Point2d)new Point2dImpl((float)shape.get(triangles[i][1], 0), (float)shape.get(triangles[i][1] + n, 0)), (Point2d)new Point2dImpl((float)shape.get(triangles[i][2], 0), (float)shape.get(triangles[i][2] + n, 0)));
            tris.add(t);
        }
        return tris;
    }

    public void setRedetectEvery(int nFrames) {
        this.fpd = nFrames;
    }
}

