/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.util;

import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.KEDetectedFace;
import org.openimaj.image.processing.face.util.DetectedFaceRenderer;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class KEDetectedFaceRenderer
implements DetectedFaceRenderer<KEDetectedFace> {
    private Float[] boundingBoxColour = RGBColour.RED;
    private Float[] pointColour = RGBColour.BLUE;

    @Override
    public void drawDetectedFace(MBFImage image, int thickness, KEDetectedFace f) {
        FacialKeypoint[] kp;
        Rectangle bounds = f.getBounds();
        image.drawShape((Shape)bounds, thickness, (Object)this.boundingBoxColour);
        for (FacialKeypoint facialKeypoint : kp = f.getKeypoints()) {
            Point2dImpl position = facialKeypoint.position.clone();
            position.translate(bounds.x, bounds.y);
            image.drawPoint((Point2d)position, (Object)this.pointColour, thickness);
        }
    }
}

