/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.alignment;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.keypoints.FKEFaceDetector;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.KEDetectedFace;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class RotateScaleAligner
implements FaceAligner<KEDetectedFace> {
    private static final FImage DEFAULT_MASK = RotateScaleAligner.loadDefaultMask();
    private int eyeDist = 68;
    private int eyePaddingLeftRight = 6;
    private int eyePaddingTop = 20;
    private FImage mask = DEFAULT_MASK;

    public RotateScaleAligner() {
    }

    public RotateScaleAligner(int targetSize) {
        int canonicalSize = 2 * this.eyePaddingLeftRight + this.eyeDist;
        double sf = targetSize / canonicalSize;
        this.eyeDist = (int)((double)this.eyeDist * sf);
        this.eyePaddingLeftRight = (targetSize - this.eyeDist) / 2;
        this.eyePaddingTop = (int)((double)this.eyePaddingTop * sf);
    }

    public RotateScaleAligner(FImage mask) {
        this.mask = mask;
    }

    @Override
    public FImage align(KEDetectedFace descriptor) {
        FacialKeypoint lefteye = descriptor.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_LEFT_LEFT);
        FacialKeypoint righteye = descriptor.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_RIGHT_RIGHT);
        float dx = righteye.position.x - lefteye.position.x;
        float dy = righteye.position.y - lefteye.position.y;
        float rotation = (float)Math.atan2(dy, dx);
        float scaling = (float)((double)this.eyeDist / Math.sqrt(dx * dx + dy * dy));
        float tx = lefteye.position.x - (float)this.eyePaddingLeftRight / scaling;
        float ty = lefteye.position.y - (float)this.eyePaddingTop / scaling;
        Matrix tf0 = TransformUtilities.scaleMatrix((double)scaling, (double)scaling).times(TransformUtilities.translateMatrix((double)(-tx), (double)(-ty))).times(TransformUtilities.rotationMatrixAboutPoint((double)(-rotation), (float)lefteye.position.x, (float)lefteye.position.y));
        Matrix tf = tf0.inverse();
        FImage J = FKEFaceDetector.pyramidResize(descriptor.getFacePatch(), tf);
        return FKEFaceDetector.extractPatch(J, tf, 2 * this.eyePaddingLeftRight + this.eyeDist, 0);
    }

    private static FImage loadDefaultMask() {
        try {
            return ImageUtilities.readF((InputStream)FaceAligner.class.getResourceAsStream("affineMask.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public FImage getMask() {
        return this.mask;
    }

    public void readBinary(DataInput in) throws IOException {
        this.eyeDist = in.readInt();
        this.eyePaddingLeftRight = in.readInt();
        this.eyePaddingTop = in.readInt();
        this.mask = ImageUtilities.readF((DataInput)in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.eyeDist);
        out.writeInt(this.eyePaddingLeftRight);
        out.writeInt(this.eyePaddingTop);
        ImageUtilities.write((Image)this.mask, (String)"png", (DataOutput)out);
    }
}

