/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import java.util.ArrayList;
import java.util.List;
import org.bridj.Pointer;
import org.bridj.ValuedEnum;
import org.openimaj.hardware.kinect.EventThread;
import org.openimaj.hardware.kinect.KinectAcceleration;
import org.openimaj.hardware.kinect.KinectDepthStream;
import org.openimaj.hardware.kinect.KinectException;
import org.openimaj.hardware.kinect.KinectIRVideoStream;
import org.openimaj.hardware.kinect.KinectLEDMode;
import org.openimaj.hardware.kinect.KinectRGBVideoStream;
import org.openimaj.hardware.kinect.KinectStream;
import org.openimaj.hardware.kinect.KinectTiltStatus;
import org.openimaj.hardware.kinect.freenect.freenect_raw_tilt_state;
import org.openimaj.hardware.kinect.freenect.freenect_registration;
import org.openimaj.hardware.kinect.freenect.libfreenectLibrary;
import org.openimaj.image.FImage;
import org.openimaj.video.VideoDisplay;

public class KinectController {
    private static final int DEPTH_X_RES = 640;
    private static final int DEPTH_Y_RES = 480;
    protected static volatile Pointer<libfreenectLibrary.freenect_context> CONTEXT;
    protected static volatile EventThread EVENT_THREAD;
    protected static volatile List<KinectController> ACTIVE_CONTROLLERS;
    protected Pointer<libfreenectLibrary.freenect_device> device;
    public KinectStream<?> videoStream;
    public KinectDepthStream depthStream;

    public KinectController(int deviceId) throws KinectException {
        this(deviceId, false, false);
    }

    public KinectController(boolean irmode) throws KinectException {
        this(0, irmode, false);
    }

    public KinectController() throws KinectException {
        this(0, false, false);
    }

    public KinectController(int deviceId, boolean irmode, boolean registeredDepthMode) throws KinectException {
        KinectController.init();
        int cd = KinectController.connectedDevices();
        if (deviceId >= cd || deviceId < 0) {
            throw new IllegalArgumentException("Invalid device id");
        }
        ACTIVE_CONTROLLERS.add(this);
        Pointer devicePtr = Pointer.pointerToPointer(null);
        libfreenectLibrary.freenect_open_device(CONTEXT, (Pointer<Pointer<libfreenectLibrary.freenect_device>>)devicePtr, deviceId);
        this.device = (Pointer)devicePtr.get();
        this.videoStream = irmode ? new KinectIRVideoStream(this) : new KinectRGBVideoStream(this);
        this.depthStream = new KinectDepthStream(this, registeredDepthMode);
    }

    public void finalize() {
        this.close();
    }

    private static synchronized void init() throws KinectException {
        if (CONTEXT == null) {
            Pointer ctxPointer = Pointer.pointerToPointer(null);
            libfreenectLibrary.freenect_init((Pointer<Pointer<libfreenectLibrary.freenect_context>>)ctxPointer, Pointer.NULL);
            if (ctxPointer == null) {
                throw new KinectException("Unable to initialise libfreenect.");
            }
            CONTEXT = (Pointer)ctxPointer.get();
            if (CONTEXT == null) {
                throw new KinectException("Unable to initialise libfreenect.");
            }
            if (libfreenectLibrary.freenect_num_devices(CONTEXT) == 0) {
                libfreenectLibrary.freenect_shutdown(CONTEXT);
                throw new KinectException("Unable to initialise libfreenect; No devices found.");
            }
            EVENT_THREAD = new EventThread();
            EVENT_THREAD.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public synchronized void run() {
                    KinectController.shutdownFreenect();
                }
            });
        }
    }

    public static synchronized void shutdownFreenect() {
        while (ACTIVE_CONTROLLERS.size() > 0) {
            ACTIVE_CONTROLLERS.get(0).close();
        }
        if (EVENT_THREAD != null) {
            EVENT_THREAD.kill();
        }
        if (CONTEXT != null) {
            libfreenectLibrary.freenect_shutdown(CONTEXT);
        }
        CONTEXT = null;
        EVENT_THREAD = null;
    }

    public void setIRMode(boolean irmode) {
        if (this.device == null) {
            return;
        }
        if (irmode) {
            if (!(this.videoStream instanceof KinectIRVideoStream)) {
                this.videoStream.stop();
                this.videoStream = new KinectIRVideoStream(this);
            }
        } else if (!(this.videoStream instanceof KinectRGBVideoStream)) {
            this.videoStream.stop();
            this.videoStream = new KinectRGBVideoStream(this);
        }
    }

    public void setRegisteredDepth(boolean rdepth) {
        if (this.device == null) {
            return;
        }
        if (this.depthStream.registered != rdepth) {
            this.depthStream.stop();
            this.depthStream = new KinectDepthStream(this, rdepth);
        }
    }

    public static synchronized int connectedDevices() throws KinectException {
        KinectController.init();
        return libfreenectLibrary.freenect_num_devices(CONTEXT);
    }

    public synchronized void close() {
        if (this.device == null) {
            return;
        }
        this.videoStream.stop();
        this.depthStream.stop();
        libfreenectLibrary.freenect_close_device(this.device);
        this.device = null;
        ACTIVE_CONTROLLERS.remove(this);
    }

    public synchronized double getTilt() {
        if (this.device == null) {
            return 0.0;
        }
        libfreenectLibrary.freenect_update_tilt_state(this.device);
        Pointer<freenect_raw_tilt_state> state = libfreenectLibrary.freenect_get_tilt_state(this.device);
        return libfreenectLibrary.freenect_get_tilt_degs(state);
    }

    public synchronized void setTilt(double angle) {
        if (this.device == null) {
            return;
        }
        if (angle < -30.0) {
            angle = -30.0;
        }
        if (angle > 30.0) {
            angle = 30.0;
        }
        libfreenectLibrary.freenect_set_tilt_degs(this.device, angle);
    }

    public synchronized KinectTiltStatus getTiltStatus() {
        if (this.device == null) {
            return null;
        }
        libfreenectLibrary.freenect_update_tilt_state(this.device);
        Pointer<freenect_raw_tilt_state> state = libfreenectLibrary.freenect_get_tilt_state(this.device);
        ValuedEnum<libfreenectLibrary.freenect_tilt_status_code> v = libfreenectLibrary.freenect_get_tilt_status(state);
        for (libfreenectLibrary.freenect_tilt_status_code c : libfreenectLibrary.freenect_tilt_status_code.values()) {
            if (c.value != v.value()) continue;
            return KinectTiltStatus.valueOf(c.name());
        }
        return null;
    }

    public synchronized void setLED(KinectLEDMode option) {
        if (this.device == null) {
            return;
        }
        libfreenectLibrary.freenect_led_options o = libfreenectLibrary.freenect_led_options.valueOf(option.name());
        libfreenectLibrary.freenect_set_led(this.device, o);
    }

    public synchronized void identify() {
        if (this.device == null) {
            return;
        }
        this.setLED(KinectLEDMode.LED_BLINK_RED_YELLOW);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setLED(KinectLEDMode.LED_GREEN);
    }

    public synchronized KinectAcceleration getAcceleration() {
        if (this.device == null) {
            return null;
        }
        Pointer px = Pointer.pointerToDouble((double)0.0);
        Pointer py = Pointer.pointerToDouble((double)0.0);
        Pointer pz = Pointer.pointerToDouble((double)0.0);
        libfreenectLibrary.freenect_update_tilt_state(this.device);
        Pointer<freenect_raw_tilt_state> state = libfreenectLibrary.freenect_get_tilt_state(this.device);
        libfreenectLibrary.freenect_get_mks_accel(state, (Pointer<Double>)px, (Pointer<Double>)py, (Pointer<Double>)pz);
        return new KinectAcceleration(px.getDouble(), py.getDouble(), pz.getDouble());
    }

    public double[] cameraToWorld(int x, int y, int depth) {
        Pointer wx = Pointer.allocateDouble();
        Pointer wy = Pointer.allocateDouble();
        libfreenectLibrary.freenect_camera_to_world(this.device, x, y, depth, (Pointer<Double>)wx, (Pointer<Double>)wy);
        return new double[]{(Double)wx.get(), (Double)wy.get(), depth};
    }

    public double computeScalingFactor() {
        int x = 321;
        double[] xyz = this.cameraToWorld(321, 0, 1000);
        return xyz[0] / 1000.0;
    }

    public float[] cameraToWorld(int x, int y, int depth, double factor) {
        float[] pt = new float[]{(float)((double)(x - 320) * factor * (double)depth), (float)((double)(y - 240) * factor * (double)depth), depth};
        return pt;
    }

    public float[] cameraToWorld(int x, int y, int depth, double factor, float[] pt) {
        pt[0] = (float)((double)(x - 320) * factor * (double)depth);
        pt[1] = (float)((double)(y - 240) * factor * (double)depth);
        pt[2] = depth;
        return pt;
    }

    public float[][] cameraToWorld(FImage regDepth, int startx, int stopx, int stepx, int starty, int stopy, int stepy) {
        freenect_registration regInfo = libfreenectLibrary.freenect_copy_registration(this.device);
        double ref_pix_size = regInfo.zero_plane_info().reference_pixel_size();
        double ref_distance = regInfo.zero_plane_info().reference_distance();
        int nx = (stopx - startx) / stepx;
        int ny = (stopy - starty) / stepy;
        float[][] points = new float[nx * ny][3];
        float[][] depths = regDepth.pixels;
        double factor = 2.0 * ref_pix_size / ref_distance;
        int i = 0;
        for (int y = starty; y < stopy; y += stepy) {
            for (int x = startx; x < stopx; x += stepx) {
                float depth = depths[y][x];
                points[i][0] = (float)((double)(x - 320) * factor * (double)depth);
                points[i][1] = (float)((double)(y - 240) * factor * (double)depth);
                points[i][2] = depth;
            }
        }
        return points;
    }

    public static void main(String[] args) throws KinectException {
        VideoDisplay.createVideoDisplay(new KinectController((int)0).videoStream);
    }

    static {
        ACTIVE_CONTROLLERS = new ArrayList<KinectController>();
    }
}

