/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher.consistent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.feature.local.matcher.consistent.ModelFittingLocalFeatureMatcher;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class ConsistentLocalFeatureMatcher2d<T extends LocalFeature<?, ?> & Point2d>
implements ModelFittingLocalFeatureMatcher<T> {
    protected LocalFeatureMatcher<T> innerMatcher;
    protected RobustModelFitting<Point2d, Point2d, ?> modelfit;
    protected List<Pair<T>> consistentMatches;

    public ConsistentLocalFeatureMatcher2d(LocalFeatureMatcher<T> innerMatcher) {
        this.innerMatcher = innerMatcher;
        this.modelfit = null;
        this.consistentMatches = new ArrayList<Pair<T>>();
    }

    public ConsistentLocalFeatureMatcher2d(LocalFeatureMatcher<T> innerMatcher, RobustModelFitting<Point2d, Point2d, ?> fit) {
        this(innerMatcher);
        this.modelfit = fit;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.consistentMatches;
    }

    public List<Pair<T>> getAllMatches() {
        return this.innerMatcher.getMatches();
    }

    @Override
    public Model<Point2d, Point2d> getModel() {
        return this.modelfit.getModel();
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.consistentMatches = new ArrayList<Pair<T>>();
        this.innerMatcher.findMatches(keys1);
        List<Pair<T>> matches = this.innerMatcher.getMatches();
        if (matches.size() < this.modelfit.numItemsToEstimate()) {
            this.consistentMatches.clear();
            this.consistentMatches.addAll(matches);
            return false;
        }
        ArrayList<Pair> li_p2d = new ArrayList<Pair>();
        for (Pair<T> m : matches) {
            li_p2d.add(new Pair(m.firstObject(), m.secondObject()));
        }
        boolean didfit = this.modelfit.fitData(li_p2d);
        Iterator iterator = this.modelfit.getInliers().iterator();
        while (iterator.hasNext()) {
            IndependentPair p;
            IndependentPair op = p = (IndependentPair)iterator.next();
            this.consistentMatches.add((Pair)op);
        }
        return didfit;
    }

    @Override
    public void setFittingModel(RobustModelFitting<Point2d, Point2d, ?> mf) {
        this.modelfit = mf;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.innerMatcher.setModelFeatures(modelkeys);
    }
}

