/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.mser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.analysis.watershed.Component;
import org.openimaj.util.tree.TreeNode;

@Reference(type=ReferenceType.Article, author={"J Matas", "O Chum", "M Urban", "T Pajdla"}, title="Robust wide-baseline stereo from maximally stable extremal regions", year="2004", journal="Image and Vision Computing", pages={"761 ", " 767"}, url="http://www.sciencedirect.com/science/article/pii/S0262885604000435", number="10", volume="22", customData={"issn", "0262-8856", "doi", "10.1016/j.imavis.2004.02.006", "keywords", "Robust metric"})
public class MSERDetector {
    private int maxArea = Integer.MAX_VALUE;
    private int minArea = 1;
    private float maxVariation = 1.0f;
    private float minDiversity = 0.0f;
    private int delta = 10;
    private TreeNode<Component> mergeTree = null;

    public MSERDetector(TreeNode<Component> mergeTree) {
        this.mergeTree = mergeTree;
    }

    public List<Component> detect() {
        List<Component> detectedRegions = this.processTree(this.mergeTree);
        return detectedRegions;
    }

    private List<Component> processTree(TreeNode<Component> mergeTree) {
        ArrayList<Component> detectedRegions = new ArrayList<Component>();
        if (mergeTree != null) {
            this.processTreeAux(mergeTree, detectedRegions, new LinkedList<TreeNode<Component>>());
        }
        return detectedRegions;
    }

    private void processTreeAux(TreeNode<Component> treeNode, List<Component> components, LinkedList<TreeNode<Component>> path) {
        float variation;
        int intensityDifference;
        Component parent;
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0 && ((Component)treeNode.getValue()).pivot.value >= this.delta) {
            path.add(treeNode);
            for (TreeNode node : treeNode.getChildren()) {
                this.processTreeAux((TreeNode<Component>)node, components, path);
            }
        }
        path.remove(treeNode);
        Component child = (Component)treeNode.getValue();
        if (child.size() < this.maxArea && child.size() > this.minArea && (parent = this.getAppropriateParent(path, child.pivot.value, this.delta)) != null && (intensityDifference = Math.abs(parent.pivot.value - child.pivot.value)) >= this.delta && (variation = intensityDifference == this.delta ? (float)Math.abs(child.size() - parent.size()) / (float)parent.size() : 0.0f) < this.maxVariation) {
            child.isMSER = true;
            components.add(child);
            for (TreeNode childNode : treeNode.getChildren()) {
                float div;
                if (!((Component)childNode.getValue()).isMSER || !((div = (float)(child.size() - ((Component)childNode.getValue()).size()) / (float)child.size()) < this.minDiversity)) continue;
                ((Component)childNode.getValue()).isMSER = false;
                components.remove(childNode.getValue());
            }
        }
    }

    private Component getAppropriateParent(LinkedList<TreeNode<Component>> path, int currentGL, int delta) {
        for (int i = path.size() - 1; i >= 0; --i) {
            if (Math.abs(((Component)path.get((int)i).getValue()).pivot.value - currentGL) < delta) continue;
            return (Component)path.get(i).getValue();
        }
        return null;
    }

    public int getMaxArea() {
        return this.maxArea;
    }

    public void setMaxArea(int maxArea) {
        this.maxArea = maxArea;
    }

    public int getMinArea() {
        return this.minArea;
    }

    public void setMinArea(int minArea) {
        this.minArea = minArea;
    }

    public float getMaxVariation() {
        return this.maxVariation;
    }

    public void setMaxVariation(float maxVariation) {
        this.maxVariation = maxVariation;
    }

    public float getMinDiversity() {
        return this.minDiversity;
    }

    public void setMinDiversity(float minDiversity) {
        this.minDiversity = minDiversity;
    }

    public TreeNode<Component> getMergeTree() {
        return this.mergeTree;
    }

    public int getDelta() {
        return this.delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }
}

