/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.mser;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.watershed.Component;
import org.openimaj.image.analysis.watershed.MergeTreeBuilder;
import org.openimaj.image.analysis.watershed.WatershedProcessor;
import org.openimaj.image.analysis.watershed.event.ComponentStackMergeListener;
import org.openimaj.image.analysis.watershed.feature.ComponentFeature;
import org.openimaj.image.feature.local.detector.mser.MSERDetector;
import org.openimaj.util.tree.TreeNode;

@Reference(type=ReferenceType.Article, author={"J Matas", "O Chum", "M Urban", "T Pajdla"}, title="Robust wide-baseline stereo from maximally stable extremal regions", year="2004", journal="Image and Vision Computing", pages={"761 ", " 767"}, url="http://www.sciencedirect.com/science/article/pii/S0262885604000435", number="10", volume="22", customData={"issn", "0262-8856", "doi", "10.1016/j.imavis.2004.02.006", "keywords", "Robust metric"})
public class MSERFeatureGenerator {
    private int delta = 10;
    private int maxArea = Integer.MAX_VALUE;
    private int minArea = 1;
    private float maxVariation = Float.MAX_VALUE;
    private float minDiversity = 0.0f;
    private Class<? extends ComponentFeature>[] featureClasses;

    @SafeVarargs
    public MSERFeatureGenerator(Class<? extends ComponentFeature> ... featureClasses) {
        this.featureClasses = featureClasses;
    }

    @SafeVarargs
    public MSERFeatureGenerator(int delta, int maxArea, int minArea, float maxVariation, float minDiversity, Class<? extends ComponentFeature> ... featureClasses) {
        this(featureClasses);
        this.delta = delta;
        this.maxArea = maxArea;
        this.minArea = minArea;
        this.maxVariation = maxVariation;
        this.minDiversity = minDiversity;
    }

    public List<Component> generateMSERs(FImage img) {
        return this.generateMSERs(img, MSERDirection.UpAndDown);
    }

    public List<Component> generateMSERs(FImage img, MSERDirection dir) {
        List<MergeTreeBuilder> mtb = this.performWatershed(img);
        List<Component> regions = this.performMSERDetection(mtb, dir);
        return regions;
    }

    public List<MergeTreeBuilder> performWatershed(FImage img) {
        WatershedProcessor watershedUp = new WatershedProcessor((Class[])this.featureClasses);
        WatershedProcessor watershedDown = new WatershedProcessor((Class[])this.featureClasses);
        MergeTreeBuilder treeBuilderUp = new MergeTreeBuilder();
        watershedUp.addComponentStackMergeListener((ComponentStackMergeListener)treeBuilderUp);
        MergeTreeBuilder treeBuilderDown = new MergeTreeBuilder();
        watershedDown.addComponentStackMergeListener((ComponentStackMergeListener)treeBuilderDown);
        watershedUp.processImage(img);
        img = img.inverse();
        watershedDown.processImage(img);
        img = img.inverse();
        ArrayList<MergeTreeBuilder> mtb = new ArrayList<MergeTreeBuilder>();
        mtb.add(treeBuilderDown);
        mtb.add(treeBuilderUp);
        return mtb;
    }

    public List<Component> performMSERDetection(List<MergeTreeBuilder> mtbs, MSERDirection dir) {
        this.clearTree((TreeNode<Component>)mtbs.get(0).getTree());
        this.clearTree((TreeNode<Component>)mtbs.get(1).getTree());
        List<Component> regionsUp = null;
        if (mtbs.get(1).getTree() != null && (dir == MSERDirection.Up || dir == MSERDirection.UpAndDown)) {
            MSERDetector mser = new MSERDetector((TreeNode<Component>)mtbs.get(1).getTree());
            mser.setDelta(this.delta);
            mser.setMaxArea(this.maxArea);
            mser.setMinArea(this.minArea);
            mser.setMaxVariation(this.maxVariation);
            mser.setMinDiversity(this.minDiversity);
            regionsUp = mser.detect();
        }
        List<Component> regionsDown = null;
        if (mtbs.get(0).getTree() != null && (dir == MSERDirection.Down || dir == MSERDirection.UpAndDown)) {
            MSERDetector mser2 = new MSERDetector((TreeNode<Component>)mtbs.get(0).getTree());
            mser2.setDelta(this.delta);
            mser2.setMaxArea(this.maxArea);
            mser2.setMinArea(this.minArea);
            mser2.setMaxVariation(this.maxVariation);
            mser2.setMinDiversity(this.minDiversity);
            regionsDown = mser2.detect();
        }
        ArrayList<Component> regions = new ArrayList<Component>();
        if (regionsUp != null) {
            regions.addAll(regionsUp);
        }
        if (regionsDown != null) {
            regions.addAll(regionsDown);
        }
        return regions;
    }

    private void clearTree(TreeNode<Component> tree) {
        if (tree == null) {
            return;
        }
        Component c = (Component)tree.getValue();
        if (c != null) {
            c.isMSER = false;
        }
        if (tree.getChildren() != null) {
            for (TreeNode child : tree.getChildren()) {
                this.clearTree((TreeNode<Component>)child);
            }
        }
    }

    public int countMSERs(TreeNode<Component> tree) {
        if (tree == null) {
            return 0;
        }
        int retVal = 0;
        Component c = (Component)tree.getValue();
        if (c != null && c.isMSER) {
            ++retVal;
        }
        if (tree.getChildren() != null) {
            for (TreeNode child : tree.getChildren()) {
                retVal += this.countMSERs((TreeNode<Component>)child);
            }
        }
        return retVal;
    }

    public int getDelta() {
        return this.delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public int getMaxArea() {
        return this.maxArea;
    }

    public void setMaxArea(int maxArea) {
        this.maxArea = maxArea;
    }

    public int getMinArea() {
        return this.minArea;
    }

    public void setMinArea(int minArea) {
        this.minArea = minArea;
    }

    public float getMaxVariation() {
        return this.maxVariation;
    }

    public void setMaxVariation(float maxVariation) {
        this.maxVariation = maxVariation;
    }

    public float getMinDiversity() {
        return this.minDiversity;
    }

    public void setMinDiversity(float minDiversity) {
        this.minDiversity = minDiversity;
    }

    public static enum MSERDirection {
        Up,
        Down,
        UpAndDown;

    }
}

