/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.pyramid;

import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.Octave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.pyramid.AbstractOctaveInterestPointFinder;

public class BasicOctaveGridFinder<OCTAVE extends Octave<?, ?, IMAGE>, IMAGE extends Image<?, IMAGE>>
extends AbstractOctaveInterestPointFinder<OCTAVE, IMAGE> {
    int skipX = 50;
    int skipY = 50;
    int borderX = 5;
    int borderY = 5;
    int startScaleIndex = 1;
    int scaleSkip = 1;
    int stopScaleIndex = 2;

    public void process(OCTAVE octave) {
        this.octave = octave;
        int scales = 0;
        if (octave instanceof GaussianOctave) {
            scales = ((GaussianPyramidOptions)((Octave)octave).options).getScales();
        }
        Image[] images = ((Octave)octave).images;
        int height = images[0].getHeight();
        int width = images[0].getWidth();
        this.currentScaleIndex = this.startScaleIndex;
        while (this.currentScaleIndex < this.stopScaleIndex) {
            for (int y = this.borderY; y < height - this.borderY; y += this.skipY) {
                for (int x = this.borderX; x < width - this.borderX; x += this.skipX) {
                    float octaveScale = this.currentScaleIndex;
                    if (octave instanceof GaussianOctave) {
                        octaveScale = ((GaussianPyramidOptions)((Octave)octave).options).getInitialSigma() * (float)Math.pow(2.0, this.currentScaleIndex / scales);
                    }
                    this.listener.foundInterestPoint(this, x, y, octaveScale);
                }
            }
            this.currentScaleIndex += this.scaleSkip;
        }
    }
}

