/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import Jama.Matrix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.combiner.AccumulatingImageCombiner;
import org.openimaj.image.feature.local.interest.AbstractStructureTensorIPD;
import org.openimaj.image.feature.local.interest.EllipticInterestPointData;
import org.openimaj.image.feature.local.interest.HarrisIPD;
import org.openimaj.image.feature.local.interest.HessianIPD;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.InterestPointVisualiser;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processing.transform.FProjectionProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.matrix.EigenValueVectorPair;
import org.openimaj.math.matrix.MatrixUtils;

public class AffineAdaption
implements MultiscaleInterestPointDetector<EllipticInterestPointData> {
    private static final FImage LAPLACIAN_KERNEL = new FImage((float[][])new float[][]{{2.0f, 0.0f, 2.0f}, {0.0f, -8.0f, 0.0f}, {2.0f, 0.0f, 2.0f}});
    private static final FConvolution LAPLACIAN_KERNEL_CONV = new FConvolution(LAPLACIAN_KERNEL);
    static Logger logger = Logger.getLogger(AffineAdaption.class);
    private AbstractStructureTensorIPD internal;
    private AbstractStructureTensorIPD initial;
    private List<EllipticInterestPointData> points;
    private IPDSelectionMode initialMode;
    private boolean fastDifferentiationScale = false;

    public AffineAdaption() {
        this(new HarrisIPD(2.0f, 2.8f), new IPDSelectionMode.Count(100));
    }

    public AffineAdaption(AbstractStructureTensorIPD internal, IPDSelectionMode initialSelectionMode) {
        this(internal, internal.clone(), initialSelectionMode);
    }

    public AffineAdaption(AbstractStructureTensorIPD internal, AbstractStructureTensorIPD initial, IPDSelectionMode initialSelectionMode) {
        this.internal = internal;
        this.initial = initial;
        this.initialMode = initialSelectionMode;
        this.points = new ArrayList<EllipticInterestPointData>();
    }

    @Override
    public void findInterestPoints(FImage image) {
        this.findInterestPoints(image, image.getBounds());
    }

    @Override
    public void findInterestPoints(FImage image, Rectangle window) {
        this.points = new ArrayList<EllipticInterestPointData>();
        this.initial.findInterestPoints(image, window);
        List<InterestPointData> a = this.initialMode.selectPoints(this.initial);
        logger.info((Object)("Found " + a.size() + " features at sd/si: " + this.initial.detectionScale + "/" + this.initial.integrationScale));
        for (InterestPointData d : a) {
            EllipticInterestPointData kpt = new EllipticInterestPointData();
            kpt.scale = this.initial.getIntegrationScale();
            kpt.x = d.x;
            kpt.y = d.y;
            boolean converge = this.calcAffineAdaptation(image, kpt, this.internal.clone());
            if (!converge) continue;
            logger.debug((Object)("Keypoint at: " + d.x + ", " + d.y));
            logger.debug((Object)("... converged: " + converge));
            this.points.add(kpt);
        }
    }

    @Override
    public List<EllipticInterestPointData> getInterestPoints(int npoints) {
        if (this.points == null) {
            return null;
        }
        if (npoints < 0) {
            npoints = this.points.size();
        }
        return this.points.subList(0, npoints < this.points.size() ? npoints : this.points.size());
    }

    @Override
    public List<EllipticInterestPointData> getInterestPoints(float threshold) {
        ArrayList<EllipticInterestPointData> validPoints = new ArrayList<EllipticInterestPointData>();
        for (EllipticInterestPointData point : this.points) {
            if (!(point.score > threshold)) continue;
            validPoints.add(point);
        }
        return validPoints;
    }

    @Override
    public List<EllipticInterestPointData> getInterestPoints() {
        return this.points;
    }

    @Override
    public void setDetectionScale(float detectionScaleVariance) {
        this.initial.setDetectionScale(detectionScaleVariance);
    }

    public void setIntegrationScale(float integrationScaleVariance) {
        this.initial.setIntegrationScale(integrationScaleVariance);
    }

    Matrix calcSecondMomentMatrix(AbstractStructureTensorIPD ipd, int x, int y) {
        return ipd.getSecondMomentsAt(x, y);
    }

    boolean calcAffineAdaptation(FImage fimage, EllipticInterestPointData kpt, AbstractStructureTensorIPD ipd) {
        int px;
        Matrix transf = new Matrix(2, 3);
        Point2dImpl c = new Point2dImpl();
        Point2dImpl p = new Point2dImpl();
        Matrix U = Matrix.identity((int)2, (int)2);
        Matrix Mk = U.copy();
        FImage warpedImg = new FImage(1, 1);
        float Qinv = 1.0f;
        float si = kpt.scale;
        float kptSize = 6.0f * kpt.scale;
        boolean divergence = false;
        boolean convergence = false;
        int i = 0;
        int py = (int)kpt.y;
        int cx = px = (int)kpt.x;
        int cy = py;
        int cxPr = cx;
        int cyPr = cy;
        float radius = kptSize / 2.0f * 1.4f;
        while (i <= 10 && !divergence && !convergence) {
            MatrixUtils.zero((Matrix)transf);
            transf.setMatrix(0, 1, 0, 1, U);
            kpt.setTransform(U);
            Rectangle boundingBox = new Rectangle();
            double ac_b2 = U.det();
            boundingBox.width = (float)Math.ceil(U.get(1, 1) / ac_b2 * 3.0 * (double)si * 1.4);
            boundingBox.height = (float)Math.ceil(U.get(0, 0) / ac_b2 * 3.0 * (double)si * 1.4);
            float half_width = Math.min((float)Math.min(fimage.width - px - 1, px), boundingBox.width);
            float half_height = Math.min((float)Math.min(fimage.height - py - 1, py), boundingBox.height);
            if (half_width <= 0.0f || half_height <= 0.0f) {
                return divergence;
            }
            int roix = Math.max(px - (int)boundingBox.width, 0);
            int roiy = Math.max(py - (int)boundingBox.height, 0);
            Rectangle roi = new Rectangle((float)roix, (float)roiy, (float)(px - roix) + half_width + 1.0f, (float)(py - roiy) + half_height + 1.0f);
            FImage img_roi = (FImage)fimage.extractROI(roi);
            p.x = px - roix;
            p.y = py - roiy;
            float u00 = (float)U.get(0, 0);
            float u01 = (float)U.get(0, 1);
            float u10 = (float)U.get(1, 0);
            float u11 = (float)U.get(1, 1);
            float minx = u01 * (float)img_roi.height < 0.0f ? u01 * (float)img_roi.height : 0.0f;
            float miny = u10 * (float)img_roi.width < 0.0f ? u10 * (float)img_roi.width : 0.0f;
            float maxx = (u00 * (float)img_roi.width > u00 * (float)img_roi.width + u01 * (float)img_roi.height ? u00 * (float)img_roi.width : u00 * (float)img_roi.width + u01 * (float)img_roi.height) - minx;
            float maxy = (u11 * (float)img_roi.width > u10 * (float)img_roi.width + u11 * (float)img_roi.height ? u11 * (float)img_roi.height : u10 * (float)img_roi.width + u11 * (float)img_roi.height) - miny;
            transf.set(0, 2, (double)(-minx));
            transf.set(1, 2, (double)(-miny));
            if (maxx >= 2.0f * radius + 1.0f && maxy >= 2.0f * radius + 1.0f) {
                FProjectionProcessor proc = new FProjectionProcessor();
                proc.setMatrix(transf);
                img_roi.accumulateWith((AccumulatingImageCombiner)proc);
                FImage warpedImgRoi = proc.performProjection(0, (int)maxx, 0, (int)maxy, null);
                c = p.transform(U);
                cx = (int)(c.x - minx);
                cy = (int)(c.y - miny);
                if ((float)warpedImgRoi.height > 2.0f * radius + 1.0f && (float)warpedImgRoi.width > 2.0f * radius + 1.0f) {
                    roix = (int)Math.max((double)cx - Math.ceil(radius), 0.0);
                    roiy = (int)Math.max((double)cy - Math.ceil(radius), 0.0);
                    roi = new Rectangle((float)roix, (float)roiy, (float)(cx - roix) + (float)Math.min(Math.ceil(radius), (double)(warpedImgRoi.width - cx - 1)) + 1.0f, (float)(cy - roiy) + (float)Math.min(Math.ceil(radius), (double)(warpedImgRoi.height - cy - 1)) + 1.0f);
                    warpedImg = (FImage)warpedImgRoi.extractROI(roi);
                    cx -= roix;
                    cy -= roiy;
                } else {
                    warpedImg.internalAssign(warpedImgRoi);
                }
                if (logger.getLevel() == Level.DEBUG) {
                    this.displayCurrentPatch(img_roi.clone().normalise(), p.x, p.y, warpedImg.clone().normalise(), cx, cy, U, si * 3.0f);
                }
                si = this.selIntegrationScale(warpedImg, si, new Pixel(cx, cy));
                ipd = this.fastDifferentiationScale ? this.selDifferentiationScaleFast(warpedImg, ipd, si, new Pixel(cx, cy)) : this.selDifferentiationScale(warpedImg, ipd, si, new Pixel(cx, cy));
                if (ipd.maxima.size() == 0) {
                    divergence = true;
                    continue;
                }
                cxPr = cx;
                cyPr = cy;
                FValuePixel max = ipd.findMaximum(new Rectangle((float)(cxPr - 1), (float)(cyPr - 1), 3.0f, 3.0f));
                cx = max.x;
                cy = max.y;
                p.x = px;
                p.y = py;
                c.x = cx - cxPr;
                c.y = cy - cyPr;
                p.translate((Point2d)c.transform(U.inverse()));
                px = (int)p.x;
                py = (int)p.y;
                float q = this.calcSecondMomentSqrt(ipd, new Pixel(cx, cy), Mk);
                float ratio = 1.0f - q;
                if (!Float.isNaN(ratio) && ratio != 1.0f) {
                    Matrix uV;
                    EigenValueVectorPair ueig;
                    Matrix uVal;
                    Qinv = this.normMaxEval(U = U.times(Mk), uVal = (ueig = MatrixUtils.symmetricEig2x2((Matrix)U)).getValues(), uV = ueig.getVectors());
                    if (Qinv >= 6.0f) {
                        logger.debug((Object)"QInverse too large, feature too edge like, affine divergence!");
                        divergence = true;
                    } else if ((double)ratio <= 0.05) {
                        convergence = true;
                        MatrixUtils.zero((Matrix)transf);
                        transf.setMatrix(0, 1, 0, 1, U);
                        kpt.x = px;
                        kpt.y = py;
                        kpt.scale = si;
                        kpt.setTransform(U);
                        kpt.score = max.value;
                    } else {
                        radius = (float)((double)(3.0f * si) * 1.4);
                    }
                } else {
                    logger.debug((Object)"QRatio was close to 0, affine divergence!");
                    divergence = true;
                }
            } else {
                logger.debug((Object)"Window size has grown too fast, scale divergence!");
                divergence = true;
            }
            ++i;
        }
        if (!divergence && !convergence) {
            logger.debug((Object)"Reached max iterations!");
        }
        return convergence;
    }

    private void displayCurrentPatch(FImage unwarped, float unwarpedx, float unwarpedy, FImage warped, int warpedx, int warpedy, Matrix transform, float scale) {
        DisplayUtilities.createNamedWindow((String)"warpunwarp", (String)"Warped and Unwarped Image", (boolean)true);
        logger.debug((Object)"Displaying patch");
        float resizeScale = 5.0f;
        float warppedPatchScale = 5.0f;
        ResizeProcessor patchSizer = new ResizeProcessor(5.0f);
        FImage warppedPatchGrey = (FImage)warped.process((SinglebandImageProcessor)patchSizer);
        MBFImage warppedPatch = new MBFImage(new FImage[]{warppedPatchGrey.clone(), warppedPatchGrey.clone(), warppedPatchGrey.clone()});
        float x = (float)warpedx * 5.0f;
        float y = (float)warpedy * 5.0f;
        float r = scale * 5.0f;
        warppedPatch.createRenderer().drawShape((Shape)new Ellipse((double)x, (double)y, (double)r, (double)r, 0.0), (Object)RGBColour.RED);
        warppedPatch.createRenderer().drawPoint((Point2d)new Point2dImpl(x, y), (Comparable[])RGBColour.RED, 3);
        FImage unwarppedPatchGrey = unwarped.clone();
        MBFImage unwarppedPatch = new MBFImage(new FImage[]{unwarppedPatchGrey.clone(), unwarppedPatchGrey.clone(), unwarppedPatchGrey.clone()});
        unwarppedPatch = (MBFImage)unwarppedPatch.process((SinglebandImageProcessor)patchSizer);
        float unwarppedPatchScale = 5.0f;
        x = unwarpedx * 5.0f;
        y = unwarpedy * 5.0f;
        Ellipse e = EllipseUtilities.fromTransformMatrix2x2((Matrix)transform, (float)x, (float)y, (float)(scale * 5.0f));
        unwarppedPatch.createRenderer().drawShape((Shape)e, (Object)RGBColour.BLUE);
        unwarppedPatch.createRenderer().drawPoint((Point2d)new Point2dImpl(x, y), (Comparable[])RGBColour.RED, 3);
        warppedPatch = (MBFImage)warppedPatch.padding(5, 5, (Object)RGBColour.BLACK);
        unwarppedPatch = (MBFImage)unwarppedPatch.padding(5, 5, (Object)RGBColour.BLACK);
        MBFImage displayArea = warppedPatch.newInstance(warppedPatch.getWidth() * 2, warppedPatch.getHeight());
        displayArea.createRenderer().drawImage(warppedPatch, 0, 0);
        displayArea.createRenderer().drawImage(unwarppedPatch, warppedPatch.getWidth(), 0);
        DisplayUtilities.displayName((Image)displayArea, (String)"warpunwarp");
        logger.debug((Object)"Done");
    }

    float selIntegrationScale(FImage image, float si, Pixel c) {
        int cx = c.x;
        int cy = c.y;
        float maxLap = -3.4028235E38f;
        float maxsx = si;
        float sigma_prev = 0.0f;
        FImage L = image.clone();
        float u = 0.7f;
        while ((double)u <= 1.41) {
            float sik = u * si;
            float sigma = (float)Math.sqrt(Math.pow(sik, 2.0) - Math.pow(sigma_prev, 2.0));
            L.processInplace((SinglebandImageProcessor)new FGaussianConvolve(sigma, 3.0f));
            sigma_prev = sik;
            float lapVal = sik * sik * Math.abs(LAPLACIAN_KERNEL_CONV.responseAt(cx, cy, L));
            if (lapVal >= maxLap) {
                maxLap = lapVal;
                maxsx = sik;
            }
            u = (float)((double)u + 0.1);
        }
        return maxsx;
    }

    float calcSecondMomentSqrt(AbstractStructureTensorIPD ipd, Pixel p, Matrix Mk) {
        Matrix M = this.calcSecondMomentMatrix(ipd, p.x, p.y);
        EigenValueVectorPair meig = MatrixUtils.symmetricEig2x2((Matrix)M);
        Matrix eigVal = meig.getValues();
        Matrix V = meig.getVectors();
        Matrix Vinv = V.inverse();
        double eval1 = Math.sqrt(eigVal.get(0, 0));
        eigVal.set(0, 0, eval1);
        double eval2 = Math.sqrt(eigVal.get(1, 1));
        eigVal.set(1, 1, eval2);
        Mk.setMatrix(0, 1, 0, 1, V.times(eigVal).times(Vinv));
        return (float)(Math.min(eval1, eval2) / Math.max(eval1, eval2));
    }

    float normMaxEval(Matrix U, Matrix uVal, Matrix uVec) {
        Matrix uVinv = uVec.inverse();
        double uval1 = uVal.get(0, 0);
        double uval2 = uVal.get(1, 1);
        if (Math.abs(uval1) < Math.abs(uval2)) {
            uVal.set(0, 0, 1.0);
            uVal.set(1, 1, uval2 / uval1);
        } else {
            uVal.set(1, 1, 1.0);
            uVal.set(0, 0, uval1 / uval2);
        }
        U.setMatrix(0, 1, 0, 1, uVec.times(uVal).times(uVinv));
        return (float)(Math.max(Math.abs(uVal.get(0, 0)), Math.abs(uVal.get(1, 1))) / Math.min(Math.abs(uVal.get(0, 0)), Math.abs(uVal.get(1, 1))));
    }

    AbstractStructureTensorIPD selDifferentiationScale(FImage img, AbstractStructureTensorIPD ipdToUse, float si, Pixel c) {
        AbstractStructureTensorIPD best = null;
        float s = 0.5f;
        float sigma_prev = 0.0f;
        double qMax = 0.0;
        FImage L = img.clone();
        AbstractStructureTensorIPD ipd = ipdToUse.clone();
        while ((double)s <= 0.751) {
            float sd = s * si;
            float sigma = (float)Math.sqrt(Math.pow(sd, 2.0) - Math.pow(sigma_prev, 2.0));
            L.processInplace((SinglebandImageProcessor)new FGaussianConvolve(sigma, 3.0f));
            sigma_prev = sd;
            ipd.setDetectionScale(sd);
            ipd.setIntegrationScale(si);
            ipd.setImageBlurred(true);
            ipd.findInterestPoints(L);
            Matrix M = this.calcSecondMomentMatrix(ipd, c.x, c.y);
            EigenValueVectorPair meig = MatrixUtils.symmetricEig2x2((Matrix)M);
            Matrix eval = meig.getValues();
            double eval1 = Math.abs(eval.get(0, 0));
            double eval2 = Math.abs(eval.get(1, 1));
            double q = Math.min(eval1, eval2) / Math.max(eval1, eval2);
            if (q >= qMax) {
                qMax = q;
                best = ipd.clone();
            }
            s = (float)((double)s + 0.05);
        }
        return best;
    }

    AbstractStructureTensorIPD selDifferentiationScaleFast(FImage img, AbstractStructureTensorIPD ipd, float si, Pixel c) {
        float sd;
        AbstractStructureTensorIPD best = ipd.clone();
        float s = 0.75f;
        FImage L = img.clone();
        float sigma = sd = 0.75f * si;
        L.processInplace((SinglebandImageProcessor)new FGaussianConvolve(sigma, 3.0f));
        best.setDetectionScale(sd);
        best.setIntegrationScale(si);
        best.setImageBlurred(true);
        best.findInterestPoints(L);
        return best;
    }

    public static void main(String[] args) throws IOException {
        float sd = 5.0f;
        float si = 7.0f;
        HessianIPD ipd = new HessianIPD(5.0f, 7.0f);
        FImage img = ImageUtilities.readF((InputStream)AffineAdaption.class.getResourceAsStream("/org/openimaj/image/data/sinaface.jpg"));
        MBFImage outImg = new MBFImage(new FImage[]{img.clone(), img.clone(), img.clone()});
        AffineAdaption adapt = new AffineAdaption(ipd, new IPDSelectionMode.Count(100));
        adapt.findInterestPoints(img);
        InterestPointVisualiser<Float[], MBFImage> ipv = InterestPointVisualiser.visualiseInterestPoints(outImg, adapt.points);
        DisplayUtilities.display((Image)ipv.drawPatches(RGBColour.BLUE, RGBColour.RED));
    }

    public void setFastDifferentiationScale(boolean b) {
        this.fastDifferentiationScale = b;
    }

    static {
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
    }
}

