/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import java.util.List;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.InterestPointDetector;

public interface IPDSelectionMode {
    public <T extends InterestPointData> List<T> selectPoints(InterestPointDetector<T> var1);

    public static class Threshold
    implements IPDSelectionMode {
        private float threshold;

        public Threshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public <T extends InterestPointData> List<T> selectPoints(InterestPointDetector<T> detector) {
            return detector.getInterestPoints(this.threshold);
        }
    }

    public static class All
    implements IPDSelectionMode {
        @Override
        public <T extends InterestPointData> List<T> selectPoints(InterestPointDetector<T> detector) {
            return detector.getInterestPoints();
        }
    }

    public static class Count
    implements IPDSelectionMode {
        private int count;

        public Count(int count) {
            this.count = count;
        }

        @Override
        public <T extends InterestPointData> List<T> selectPoints(InterestPointDetector<T> detector) {
            return detector.getInterestPoints(this.count);
        }
    }
}

