/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.local.ScaleSpaceLocation;
import org.openimaj.math.geometry.shape.Ellipse;

public class InterestPointData
extends ScaleSpaceLocation {
    private static final long serialVersionUID = 6710204268210799061L;
    public float score;

    public InterestPointData clone() {
        InterestPointData d = (InterestPointData)super.clone();
        d.score = this.score;
        return d;
    }

    boolean equalPos(InterestPointData otherPos) {
        return otherPos.x == this.x && otherPos.y == this.y && otherPos.scale == this.scale;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.score == ((InterestPointData)((Object)other)).score;
    }

    public Ellipse getEllipse() {
        return new Ellipse((double)this.x, (double)this.y, (double)(this.scale * this.scale), (double)(this.scale * this.scale), 0.0);
    }

    public Matrix getTransform() {
        return Matrix.identity((int)3, (int)3);
    }

    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        out.writeFloat(this.score);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        super.writeASCII(out);
        out.format(" %4.2f", Float.valueOf(this.score));
    }

    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.score = in.readFloat();
    }

    public void readASCII(Scanner in) throws IOException {
        super.readASCII(in);
        this.score = in.nextFloat();
    }
}

