/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.util.pair.Pair;

public class FastLimitedEuclideanKeypointMatcher<T extends Keypoint>
implements LocalFeatureMatcher<T> {
    private ByteNearestNeighboursKDTree modelKeypointsKNN;
    private int limit;
    private List<Pair<T>> matches;
    private List<T> modelKeypoints;

    public FastLimitedEuclideanKeypointMatcher(int limit) {
        this.limit = limit;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = modelkeys;
        byte[][] data = new byte[modelkeys.size()][];
        for (int i = 0; i < modelkeys.size(); ++i) {
            data[i] = ((Keypoint)modelkeys.get((int)i)).ivec;
        }
        this.modelKeypointsKNN = new ByteNearestNeighboursKDTree((byte[][])data, 8, 768);
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        int i;
        PriorityQueue<WPair> mq = new PriorityQueue<WPair>();
        byte[][] data = new byte[keys1.size()][];
        for (int i2 = 0; i2 < keys1.size(); ++i2) {
            data[i2] = ((Keypoint)keys1.get((int)i2)).ivec;
        }
        int[] argmins = new int[keys1.size()];
        float[] mins = new float[keys1.size()];
        this.modelKeypointsKNN.searchNN((byte[][])data, argmins, mins);
        for (i = 0; i < keys1.size(); ++i) {
            float distsq = mins[i];
            mq.add(new WPair(this, (Keypoint)keys1.get(i), (Keypoint)this.modelKeypoints.get(argmins[i]), distsq));
        }
        this.matches = new ArrayList<Pair<T>>(this.limit);
        for (i = 0; i < this.limit; ++i) {
            this.matches.add((Pair<T>)mq.poll());
        }
        return true;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.matches;
    }

    class WPair
    extends Pair<T>
    implements Comparable<WPair> {
        float weight;
        final /* synthetic */ FastLimitedEuclideanKeypointMatcher this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public WPair(T obj1, T obj2, float weight) {
            this.this$0 = (FastLimitedEuclideanKeypointMatcher)f;
            super(obj1, obj2);
            this.weight = weight;
        }

        @Override
        public int compareTo(WPair o) {
            if (this.weight == o.weight) {
                return 0;
            }
            if (this.weight < o.weight) {
                return -1;
            }
            return 1;
        }
    }
}

