/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.pyramid;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.Octave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.feature.local.detector.dog.pyramid.DoGOctave;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointListener;

public class DoGOctaveExtremaFinder
implements OctaveInterestPointFinder<GaussianOctave<FImage>, FImage>,
OctaveInterestPointListener<GaussianOctave<FImage>, FImage> {
    GaussianOctave<FImage> gaussianOctave;
    DoGOctave<FImage> dogOctave;
    OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> innerFinder;
    OctaveInterestPointListener<GaussianOctave<FImage>, FImage> listener;

    public DoGOctaveExtremaFinder(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder) {
        this.innerFinder = finder;
        finder.setOctaveInterestPointListener(this);
    }

    public DoGOctaveExtremaFinder(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder, OctaveInterestPointListener<GaussianOctave<FImage>, FImage> listener) {
        this(finder);
        this.listener = listener;
    }

    @Override
    public void setOctaveInterestPointListener(OctaveInterestPointListener<GaussianOctave<FImage>, FImage> listener) {
        this.listener = listener;
    }

    @Override
    public OctaveInterestPointListener<GaussianOctave<FImage>, FImage> getOctaveInterestPointListener() {
        return this.listener;
    }

    public void process(GaussianOctave<FImage> octave) {
        this.gaussianOctave = octave;
        this.dogOctave = new DoGOctave((GaussianPyramid)octave.parentPyramid, octave.octaveSize);
        this.dogOctave.process(octave);
        this.innerFinder.process((Octave)this.dogOctave);
    }

    @Override
    public GaussianOctave<FImage> getOctave() {
        return this.gaussianOctave;
    }

    public GaussianOctave<FImage> getDoGOctave() {
        return this.dogOctave;
    }

    @Override
    public int getCurrentScaleIndex() {
        return this.innerFinder.getCurrentScaleIndex();
    }

    @Override
    public void foundInterestPoint(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder, float x, float y, float octaveScale) {
        if (this.listener != null) {
            this.listener.foundInterestPoint(this, x, y, octaveScale);
        }
    }
}

