/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.ipd.finder;

import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.OctaveProcessor;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.ipd.collector.InterestPointFeatureCollector;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.InterestPointDetector;

public class OctaveInterestPointFinder<T extends InterestPointData>
implements OctaveProcessor<GaussianOctave<FImage>, FImage> {
    protected InterestPointDetector<T> detector;
    protected InterestPointFeatureCollector<T> listener;
    protected IPDSelectionMode selectionMode;
    static Logger logger = Logger.getLogger(OctaveInterestPointFinder.class);

    public OctaveInterestPointFinder(InterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
        this.detector = detector;
        this.selectionMode = selectionMode;
    }

    public void process(GaussianOctave<FImage> octave) {
        for (int currentScaleIndex = 0; currentScaleIndex < ((FImage[])octave.images).length; ++currentScaleIndex) {
            FImage fImage = ((FImage[])octave.images)[currentScaleIndex];
            float currentScale = (float)((double)((GaussianPyramidOptions)octave.options).getInitialSigma() * Math.pow(2.0, (float)currentScaleIndex / (float)((GaussianPyramidOptions)octave.options).getScales()));
            this.detector.setDetectionScale(currentScale);
            this.detector.findInterestPoints(fImage);
            List<T> points = this.selectionMode.selectPoints(this.detector);
            this.processOctaveLevelPoints(fImage, points, currentScale, octave.octaveSize);
        }
    }

    protected void processOctaveLevelPoints(FImage fImage, List<T> points, float currentScale, float octaveSize) {
        logger.info((Object)String.format("At octave scale %4.2f (absolute scale %4.2f) %d points detected", Float.valueOf(currentScale), Float.valueOf(currentScale * octaveSize), points.size()));
        for (InterestPointData point : points) {
            this.listener.foundInterestPoint(fImage, point, octaveSize);
        }
    }

    public void setOctaveInterestPointListener(InterestPointFeatureCollector<T> listener) {
        this.listener = listener;
    }

    public void finish() {
    }

    static {
        BasicConfigurator.configure();
    }
}

