/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest.experiment;

import Jama.Matrix;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.feature.local.detector.ipd.collector.CircularInterestPointKeypoint;
import org.openimaj.image.feature.local.engine.ipd.FinderMode;
import org.openimaj.image.feature.local.engine.ipd.IPDSIFTEngine;
import org.openimaj.image.feature.local.interest.AffineAdaption;
import org.openimaj.image.feature.local.interest.HarrisIPD;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.experiment.IPDRepeatability;
import org.openimaj.image.feature.local.keypoints.InterestPointKeypoint;
import org.openimaj.io.IOUtils;

public class OxfordRepeatabilityExperiment {
    private static final String DEFAULT_FEATURE_DUMP_PATH = "/tmp/featurePath";
    static Logger logger = Logger.getLogger(AffineAdaption.class);
    private int nExperiments;
    private String transformName;
    private String imageName;
    private HashMap<String, List<InterestPointData>> features;
    private HashMap<String, Matrix> transforms;
    private HashMap<String, MBFImage> images;
    private ExperimentFeatureExtraction experiemtnFeatureExtraction;
    private String featureDumpPath = "/tmp/featurePath";

    OxfordRepeatabilityExperiment(String experimentRoot, String transformName, String imageName, int nImages, ExperimentFeatureExtraction expFE, String featureDumpPath) throws IOException {
        this.nExperiments = nImages - 1;
        this.transformName = transformName;
        this.imageName = imageName;
        this.experiemtnFeatureExtraction = expFE;
        this.featureDumpPath = featureDumpPath;
        this.transforms = new HashMap();
        this.images = new HashMap();
        String imageNameFormated = String.format(imageName, 1);
        String imageLocation = experimentRoot + "/" + imageNameFormated;
        logger.debug((Object)("Loading image: " + imageLocation));
        MBFImage im = ImageUtilities.readMBF((InputStream)this.getClass().getResourceAsStream(imageLocation));
        if (im == null) {
            throw new IOException("Can't load image: " + imageLocation);
        }
        this.images.put(imageNameFormated, im);
        for (int i = 1; i < nImages; ++i) {
            String transformNameFormated = String.format(transformName, 1, i + 1);
            String transformLocation = experimentRoot + "/" + transformNameFormated;
            logger.debug((Object)("Loading trasnform: " + transformLocation));
            this.transforms.put(transformNameFormated, IPDRepeatability.readHomography(this.getClass().getResourceAsStream(transformLocation)));
            imageNameFormated = String.format(imageName, i + 1);
            imageLocation = experimentRoot + "/" + imageNameFormated;
            logger.debug((Object)("Loading image: " + imageLocation));
            this.images.put(imageNameFormated, ImageUtilities.readMBF((InputStream)this.getClass().getResourceAsStream(imageLocation)));
        }
        this.features = new HashMap();
    }

    public OxfordRepeatabilityExperiment(String expBase, String transformName, String imgName, int nExperiments, ExperimentFeatureExtraction experiemtnFeatureExtraction) throws IOException {
        this(expBase, transformName, imgName, nExperiments, experiemtnFeatureExtraction, DEFAULT_FEATURE_DUMP_PATH);
    }

    public IPDRepeatability<InterestPointData> experimentWith(int n) throws ExperimentException {
        if (n > this.nExperiments) {
            return null;
        }
        String image1Name = String.format(this.imageName, 1);
        String image2Name = String.format(this.imageName, n + 1);
        if (!this.images.containsKey(image1Name) || this.images.get(image1Name) == null) {
            throw new ExperimentException("Couldn't load: " + image1Name);
        }
        if (!this.images.containsKey(image2Name)) {
            throw new ExperimentException("Couldn't load: " + image2Name);
        }
        List<InterestPointData> image1Features = this.getFeatures(image1Name);
        List<InterestPointData> image2Features = this.getFeatures(image2Name);
        if (image1Features == null || image2Features == null) {
            throw new ExperimentException("Couldn't load features correctly");
        }
        String transformNameFormatted = String.format(this.transformName, 1, n + 1);
        if (!this.transforms.containsKey(transformNameFormatted)) {
            throw new ExperimentException("Couldn't load: " + transformNameFormatted);
        }
        return IPDRepeatability.repeatability(this.images.get(image1Name), this.images.get(image2Name), image1Features, image2Features, this.transforms.get(transformNameFormatted), 4);
    }

    private List<InterestPointData> getFeatures(String imageNameFormatted) {
        if (!this.features.containsKey(imageNameFormatted)) {
            File featureDump = new File(this.featureDumpPath, String.format("%s/%s.%s", this.experiemtnFeatureExtraction.experimentName(), imageNameFormatted, this.experiemtnFeatureExtraction.experimentName()));
            featureDump.getParentFile().mkdir();
            LocalFeatureList kpts = null;
            if (featureDump.exists()) {
                try {
                    kpts = MemoryLocalFeatureList.read((File)featureDump, CircularInterestPointKeypoint.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kpts == null) {
                IPDSIFTEngine engine = this.experiemtnFeatureExtraction.engine();
                kpts = engine.findFeatures(Transforms.calculateIntensityNTSC((MBFImage)this.images.get(imageNameFormatted)));
                try {
                    IOUtils.writeBinary((File)featureDump, kpts);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ArrayList ipts = new ArrayList();
            for (InterestPointKeypoint interestPointKeypoint : kpts) {
                ipts.add(interestPointKeypoint.location);
            }
            this.features.put(imageNameFormatted, ipts);
        }
        return this.features.get(imageNameFormatted);
    }

    public static void main(String[] args) throws IOException, ExperimentException {
        String expBase = "/org/openimaj/image/feature/validator/graf";
        String imgName = "img%d.ppm";
        OxfordRepeatabilityExperiment exp = new OxfordRepeatabilityExperiment(expBase, "H%dto%dp", imgName, 6, new ExperimentFeatureExtraction.Harris());
        for (int i = 1; i < 6; ++i) {
            IPDRepeatability<InterestPointData> experiment = exp.experimentWith(i);
            System.out.println(String.format(imgName + ": %f", i + 1, experiment.repeatability(0.6f)));
        }
    }

    static {
        BasicConfigurator.configure();
        logger.setLevel(Level.DEBUG);
    }

    static interface ExperimentFeatureExtraction {
        public String experimentName();

        public IPDSIFTEngine engine();

        public static class Harris
        implements ExperimentFeatureExtraction {
            @Override
            public String experimentName() {
                return "harris";
            }

            @Override
            public IPDSIFTEngine engine() {
                HarrisIPD hIPD = new HarrisIPD(1.4f);
                hIPD.setImageBlurred(true);
                IPDSIFTEngine engine = new IPDSIFTEngine(hIPD);
                engine.setSelectionMode(new IPDSelectionMode.Threshold(10000.0f));
                engine.setAcrossScales(true);
                engine.setFinderMode(new FinderMode.Characteristic());
                return engine;
            }
        }

        public static class AffineHarris
        implements ExperimentFeatureExtraction {
            @Override
            public String experimentName() {
                return "affineharris";
            }

            @Override
            public IPDSIFTEngine engine() {
                return null;
            }
        }
    }

    static class ExperimentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExperimentException(String string) {
            super(string);
        }
    }
}

