/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import Jama.Matrix;
import cern.jet.random.Normal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.openimaj.feature.ByteFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.image.feature.local.keypoints.KeypointLocation;
import org.openimaj.io.VariableLength;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.ScaleSpacePoint;

public class Keypoint
implements Serializable,
ScaleSpacePoint,
LocalFeature<KeypointLocation, ByteFV>,
VariableLength,
Cloneable {
    static final long serialVersionUID = 1234554345L;
    private static final int DEFAULT_LENGTH = 128;
    public byte[] ivec;
    public float ori;
    public float scale;
    public float x;
    public float y;

    public Keypoint() {
        this.ivec = new byte[128];
    }

    public Keypoint(int length) {
        if (length < 0) {
            length = 128;
        }
        this.ivec = new byte[length];
    }

    public Keypoint(float x, float y, float ori, float scale, byte[] ivec) {
        this.x = x;
        this.y = y;
        this.ori = ori;
        this.scale = scale;
        this.ivec = ivec;
    }

    public Keypoint(Keypoint k) {
        this(k.x, k.y, k.ori, k.scale, Arrays.copyOf(k.ivec, k.ivec.length));
    }

    public Float getOrdinate(int dimension) {
        if (dimension == 0) {
            return Float.valueOf(this.x);
        }
        if (dimension == 1) {
            return Float.valueOf(this.y);
        }
        if (dimension == 2) {
            return Float.valueOf(this.scale);
        }
        return null;
    }

    public int getDimensions() {
        return 3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public String toString() {
        return "Keypoint(" + this.x + ", " + this.y + ", " + this.scale + ", " + this.ori + ")";
    }

    public boolean locationEquals(Object obj) {
        if (obj instanceof Keypoint) {
            Keypoint kobj = (Keypoint)obj;
            if (kobj.x == this.x && kobj.y == this.y && kobj.scale == this.scale) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Keypoint) {
            Keypoint kobj = (Keypoint)obj;
            if (kobj.x == this.x && kobj.y == this.y && kobj.scale == this.scale && Arrays.equals(this.ivec, kobj.ivec)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + Float.floatToIntBits(this.y);
        hash = hash * 31 + Float.floatToIntBits(this.x);
        hash = hash * 31 + Float.floatToIntBits(this.scale);
        return hash;
    }

    public Keypoint clone() {
        Keypoint clone = new Keypoint();
        clone.x = this.x;
        clone.ori = this.ori;
        clone.y = this.y;
        clone.scale = this.scale;
        clone.ivec = new byte[this.ivec.length];
        System.arraycopy(this.ivec, 0, clone.ivec, 0, this.ivec.length);
        return clone;
    }

    public void copyFrom(Point2d p) {
        this.setX(p.getX());
        this.setY(p.getY());
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.getLocation().writeBinary(out);
        out.write(this.ivec);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.getLocation().writeASCII(out);
        for (int i = 0; i < this.ivec.length; ++i) {
            if (i > 0 && i % 20 == 0) {
                out.println();
            }
            out.print(" " + (this.ivec[i] + 128));
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        KeypointLocation l = this.getLocation();
        l.readBinary(in);
        this.setLocation(l);
        in.readFully(this.ivec);
    }

    public void readASCII(Scanner in) throws IOException {
        KeypointLocation l = this.getLocation();
        l.readASCII(in);
        this.setLocation(l);
        int i = 0;
        while (i < this.ivec.length) {
            String line = in.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                this.ivec[i] = (byte)(Integer.parseInt(st.nextToken()) - 128);
                ++i;
            }
        }
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public String asciiHeader() {
        return "";
    }

    public ByteFV getFeatureVector() {
        return new ByteFV(this.ivec);
    }

    public KeypointLocation getLocation() {
        return new KeypointLocation(this.x, this.y, this.ori, this.scale);
    }

    public void setLocation(KeypointLocation location) {
        this.x = location.x;
        this.y = location.y;
        this.scale = location.scale;
        this.ori = location.orientation;
    }

    public static List<Keypoint> getRelativeKeypoints(List<Keypoint> keypoints, float x, float y) {
        ArrayList<Keypoint> shifted = new ArrayList<Keypoint>();
        for (Keypoint old : keypoints) {
            Keypoint n = new Keypoint();
            n.x = old.x - x;
            n.y = old.y - y;
            n.ivec = old.ivec;
            n.scale = old.scale;
            n.ori = old.ori;
            shifted.add(n);
        }
        return shifted;
    }

    public static List<Keypoint> addGaussianNoise(List<Keypoint> siftFeatures, double mean, double sigma) {
        ArrayList<Keypoint> toRet = new ArrayList<Keypoint>();
        for (Keypoint keypoint : siftFeatures) {
            Keypoint kpClone = keypoint.clone();
            for (int i = 0; i < keypoint.ivec.length; ++i) {
                double deviation = Normal.staticNextDouble((double)mean, (double)sigma);
                int value = 0xFF & keypoint.ivec[i];
                if ((value = (int)((double)value + deviation)) < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                kpClone.ivec[i] = (byte)value;
            }
            toRet.add(kpClone);
        }
        return toRet;
    }

    public static List<Keypoint> getScaledKeypoints(List<Keypoint> keypoints, int toScale) {
        ArrayList<Keypoint> shifted = new ArrayList<Keypoint>();
        for (Keypoint old : keypoints) {
            Keypoint n = new Keypoint();
            n.x = old.x * (float)toScale;
            n.y = old.y * (float)toScale;
            n.ivec = old.ivec;
            n.scale = old.scale * (float)toScale;
            n.ori = old.ori;
            shifted.add(n);
        }
        return shifted;
    }

    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    public Keypoint transform(Matrix transform) {
        float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
        float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
        float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
        return new Keypoint(xt /= zt, yt /= zt, this.ori, this.scale, (byte[])this.ivec.clone());
    }

    public Point2d minus(Point2d a) {
        Keypoint kp = this.clone();
        kp.x = this.x - (float)((int)a.getX());
        kp.y = this.y - (float)((int)a.getY());
        return null;
    }

    public void translate(Point2d v) {
        this.translate(v.getX(), v.getY());
    }

    public Point2d copy() {
        return this.clone();
    }
}

