/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.pyramid;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.resize.BilinearInterpolation;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.Processor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.util.array.ArrayIterator;

public class SimplePyramid<IMAGE extends Image<?, IMAGE>>
implements ImageAnalyser<IMAGE>,
ImageProcessor<IMAGE>,
Iterable<IMAGE> {
    public IMAGE[] pyramid;
    Processor<IMAGE> processor = null;
    float power;
    int nlevels;

    public SimplePyramid(float power) {
        this.power = power;
        this.nlevels = -1;
    }

    public SimplePyramid(float power, int nlevels) {
        this.power = power;
        this.nlevels = nlevels;
    }

    public SimplePyramid(float power, Processor<IMAGE> processor) {
        this.power = power;
        this.nlevels = -1;
        this.processor = processor;
    }

    public SimplePyramid(float power, int nlevels, Processor<IMAGE> processor) {
        this.power = power;
        this.nlevels = nlevels;
        this.processor = processor;
    }

    protected int computeLevels(int size) {
        int levels = 1;
        while ((size = (int)((float)size / this.power)) >= 8) {
            ++levels;
        }
        return levels;
    }

    public void analyseImage(IMAGE image) {
        if (this.nlevels <= 0) {
            this.nlevels = this.computeLevels(Math.min(image.getWidth(), image.getHeight()));
        }
        this.pyramid = (Image[])Array.newInstance(image.getClass(), this.nlevels);
        for (int i = 0; i < this.nlevels; ++i) {
            this.pyramid[i] = image;
            int m = (int)Math.floor((float)image.getHeight() / this.power);
            int n = (int)Math.floor((float)image.getWidth() / this.power);
            image = ((SinglebandImageProcessor.Processable)image.process(this.processor)).process((SinglebandImageProcessor)new BilinearInterpolation(n, m, this.power));
        }
    }

    public void processImage(IMAGE image) {
        this.analyseImage(image);
        image.internalAssign(this.pyramid[this.nlevels - 1]);
    }

    @Override
    public Iterator<IMAGE> iterator() {
        return new ArrayIterator((Object[])this.pyramid);
    }

    public static <T extends Image<?, T>> SimplePyramid<T> createGaussianPyramid(T image, float sigma, int nLevels) {
        SimplePyramid pyr = new SimplePyramid(2.0f, nLevels, (Processor)new FGaussianConvolve(sigma));
        image.analyseWith(pyr);
        return pyr;
    }
}

