/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed.feature;

import Jama.Matrix;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.watershed.feature.ComponentFeature;
import org.openimaj.image.pixel.IntValuePixel;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.util.QuadraticEquation;

public class MomentFeature
implements ComponentFeature {
    int n = 0;
    double mx = 0.0;
    double my = 0.0;
    double Mx2 = 0.0;
    double My2 = 0.0;
    double sxy = 0.0;
    double sx = 0.0;
    double sy = 0.0;

    @Override
    public void merge(ComponentFeature f) {
        MomentFeature mf = (MomentFeature)f;
        double dx = mf.mx - this.mx;
        double dy = mf.my - this.my;
        this.mx = ((double)this.n * this.mx + (double)mf.n * mf.mx) / (double)(this.n + mf.n);
        this.my = ((double)this.n * this.my + (double)mf.n * mf.my) / (double)(this.n + mf.n);
        this.Mx2 += mf.Mx2 + dx * dx * (double)this.n * (double)mf.n / (double)(this.n + mf.n);
        this.My2 += mf.My2 + dy * dy * (double)this.n * (double)mf.n / (double)(this.n + mf.n);
        this.n += mf.n;
        this.sxy += mf.sxy;
        this.sx += mf.sx;
        this.sy += mf.sy;
    }

    @Override
    public void addSample(IntValuePixel p) {
        ++this.n;
        double dx = (double)p.x - this.mx;
        double dy = (double)p.y - this.my;
        this.mx += dx / (double)this.n;
        this.my += dy / (double)this.n;
        this.Mx2 += dx * ((double)p.x - this.mx);
        this.My2 += dy * ((double)p.y - this.my);
        this.sx += (double)p.x;
        this.sy += (double)p.y;
        this.sxy += (double)(p.x * p.y);
    }

    public double n() {
        return this.n;
    }

    public double u11() {
        return (this.sxy - this.sx * this.sy / (double)this.n) / (double)this.n;
    }

    public double u20() {
        return this.Mx2 / (double)this.n;
    }

    public double u02() {
        return this.My2 / (double)this.n;
    }

    public double m10() {
        return this.mx;
    }

    public double m01() {
        return this.my;
    }

    @Override
    public MomentFeature clone() {
        try {
            return (MomentFeature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Ellipse getEllipse() {
        return this.getEllipse(1.0f);
    }

    public Ellipse getEllipse(float sf) {
        float u = (float)this.m10();
        float v = (float)this.m01();
        Matrix sm = new Matrix((double[][])new double[][]{{this.u20(), this.u11()}, {this.u11(), this.u02()}});
        return EllipseUtilities.ellipseFromCovariance((float)u, (float)v, (Matrix)sm, (float)sf);
    }

    public Circle getCircle(float sf) {
        Ellipse e = this.getEllipse(sf);
        Point2d p = e.getCOG();
        return new Circle(p.getX(), p.getY(), (float)(e.getMajor() + e.getMinor()) / 2.0f);
    }

    public Polygon getEllipseBoundingBox(float sf) {
        return this.getEllipse(sf).calculateOrientedBoundingBox();
    }

    public double getOrientation() {
        double xx = this.u20();
        double xy = this.u11();
        double yy = this.u02();
        return 0.5 * Math.atan2(2.0 * xy, xx - yy);
    }

    protected double[] getEllipseBoundingRectsData(double sf) {
        double xx = this.u20();
        double xy = this.u11();
        double yy = this.u02();
        double theta = 0.5 * Math.atan2(2.0 * xy, xx - yy);
        double trace = xx + yy;
        double det = xx * yy - xy * xy;
        double[] eigval = QuadraticEquation.solveGeneralQuadratic((double)1.0, (double)(-1.0 * trace), (double)det);
        double a = 1.0 + Math.sqrt(Math.abs(eigval[1])) * sf * 4.0;
        double b = 1.0 + Math.sqrt(Math.abs(eigval[0])) * sf * 4.0;
        double[] data = new double[]{Math.max(a, b), Math.min(a, b), theta};
        return data;
    }

    public FImage extractEllipsePatch(FImage image, double sf) {
        double[] data = this.getEllipseBoundingRectsData(sf);
        double height = data[1];
        double width = data[0];
        double ori = data[2];
        int sx = (int)Math.rint(width);
        int sy = (int)Math.rint(height);
        FImage patch = new FImage(sx, sy);
        for (int y = 0; y < sy; ++y) {
            for (int x = 0; x < sx; ++x) {
                double xbar = (double)x - (double)sx / 2.0;
                double ybar = (double)y - (double)sy / 2.0;
                double xx = xbar * Math.cos(ori) - ybar * Math.sin(ori) + this.mx;
                double yy = xbar * Math.sin(ori) + ybar * Math.cos(ori) + this.my;
                patch.setPixel(x, y, image.getPixelInterp(xx, yy));
            }
        }
        return patch;
    }
}

