/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class DifferenceOfGaussian
implements ImageProcessor<FImage> {
    FGaussianConvolve filter1;
    FGaussianConvolve filter2;

    public DifferenceOfGaussian() {
        this(1.0f, 2.0f);
    }

    public DifferenceOfGaussian(float sigma1, float sigma2) {
        this.filter1 = new FGaussianConvolve(sigma1);
        this.filter2 = new FGaussianConvolve(sigma2);
    }

    public void processImage(FImage image) {
        FImage blur1 = (FImage)image.process((SinglebandImageProcessor)this.filter1);
        FImage blur2 = (FImage)image.process((SinglebandImageProcessor)this.filter2);
        image.internalAssign(blur1.subtractInplace(blur2));
    }
}

