/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class EqualisationProcessor
implements SinglebandImageProcessor<Float, FImage> {
    public void processImage(FImage image) {
        int[] hg = new int[256];
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                int i;
                int n = i = Math.round(255.0f * image.pixels[r][c]);
                hg[n] = hg[n] + 1;
            }
        }
        for (int i = 1; i < 256; ++i) {
            int n = i;
            hg[n] = hg[n] + hg[i - 1];
        }
        float alpha = 255.0f / (float)(image.getWidth() * image.getHeight());
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                int i = Math.round(255.0f * image.pixels[r][c]);
                image.pixels[r][c] = (float)Math.round((float)hg[i] * alpha) / 255.0f;
            }
        }
    }
}

