/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class MaxFilter
implements SinglebandImageProcessor<Float, FImage> {
    private int[][] support;

    public MaxFilter(int[][] support) {
        this.support = support;
    }

    public void processImage(FImage image) {
        FImage tmpImage = new FImage(image.width, image.height);
        float max = -3.4028235E38f;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                for (int i = 0; i < this.support.length; ++i) {
                    int xx = x + this.support[i][0];
                    int yy = y + this.support[i][1];
                    if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1) continue;
                    max = Math.max(max, image.pixels[yy][xx]);
                }
                tmpImage.pixels[y][x] = max;
            }
        }
        image.internalAssign(tmpImage);
    }
}

