/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class MedianFilter
implements SinglebandImageProcessor<Float, FImage> {
    private int[][] support;

    public MedianFilter(int[][] support) {
        this.support = support;
    }

    public void processImage(FImage image) {
        float[] tmp = new float[this.support.length];
        FImage tmpImage = new FImage(image.width, image.height);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int count = 0;
                for (int i = 0; i < this.support.length; ++i) {
                    int xx = x + this.support[i][0];
                    int yy = y + this.support[i][1];
                    if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1) continue;
                    tmp[count++] = image.pixels[yy][xx];
                }
                tmpImage.pixels[y][x] = FloatArrayStatsUtils.median((float[])tmp, (int)0, (int)count);
            }
        }
        image.internalAssign(tmpImage);
    }
}

