/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class MinMaxAnalyser
implements ImageAnalyser<FImage> {
    private int[][] support;
    public FImage min;
    public FImage max;

    public MinMaxAnalyser(int[][] support) {
        this.support = support;
    }

    public void analyseImage(FImage image) {
        this.min = new FImage(image.width, image.height);
        this.max = new FImage(image.width, image.height);
        float minv = Float.MAX_VALUE;
        float maxv = -3.4028235E38f;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                for (int i = 0; i < this.support.length; ++i) {
                    int xx = x + this.support[i][0];
                    int yy = y + this.support[i][1];
                    if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1) continue;
                    minv = Math.min(minv, this.min.pixels[yy][xx]);
                    maxv = Math.max(maxv, this.max.pixels[yy][xx]);
                }
                this.min.pixels[y][x] = minv;
                this.max.pixels[y][x] = maxv;
            }
        }
    }
}

