/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class FDiscGausConvolve
implements SinglebandImageProcessor<Float, FImage> {
    private float sigma2;

    public FDiscGausConvolve(float sigma2) {
        this.sigma2 = sigma2;
    }

    public void processImage(FImage image) {
        int c;
        int r;
        int cs = image.getCols();
        int rs = image.getRows();
        FloatFFT_2D fft = new FloatFFT_2D(rs, cs);
        float[][] prepared = new float[rs][cs * 2];
        for (r = 0; r < rs; ++r) {
            for (c = 0; c < cs; ++c) {
                prepared[r][c * 2] = image.pixels[r][c];
                prepared[r][1 + c * 2] = 0.0f;
            }
        }
        fft.complexForward(prepared);
        for (int y = 0; y < rs; ++y) {
            for (int x = 0; x < cs; ++x) {
                double xcos = Math.cos(Math.PI * 2 * (double)((float)x / (float)cs));
                double ycos = Math.cos(Math.PI * 2 * (double)((float)y / (float)rs));
                float multiply = (float)Math.exp((double)this.sigma2 * (xcos + ycos - 2.0));
                prepared[y][x * 2] = prepared[y][x * 2] * multiply;
                prepared[y][1 + x * 2] = prepared[y][1 + x * 2] * multiply;
            }
        }
        fft.complexInverse(prepared, true);
        for (r = 0; r < rs; ++r) {
            for (c = 0; c < cs; ++c) {
                image.pixels[r][c] = prepared[r][c * 2];
            }
        }
    }
}

