/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;

public abstract class FilterBank
implements ImageProcessor<FImage> {
    protected FConvolution[] filters;
    protected FImage[] responses;

    public void processImage(FImage image) {
        this.responses = new FImage[this.filters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            this.responses[i] = (FImage)image.process((SinglebandImageProcessor)this.filters[i]);
        }
    }

    public FImage[] getResponseImages() {
        return this.responses;
    }

    public float[] getResponse(int x, int y) {
        float[] response = new float[this.responses.length];
        for (int i = 0; i < response.length; ++i) {
            response[i] = this.responses[i].getPixelNative(x, y);
        }
        return response;
    }

    public FloatFV getResponseFV(int x, int y) {
        return new FloatFV(this.getResponse(x, y));
    }

    public FImage renderFilters(int numFiltersX) {
        int border = 4;
        int numFiltersY = (int)Math.ceil((double)this.filters.length / (double)numFiltersX);
        int w = border + this.filters[0].kernel.width;
        int width = w * numFiltersX + border;
        int h = border + this.filters[0].kernel.height;
        int height = h * numFiltersY + border;
        FImage image = new FImage(width, height);
        image.fill(1.0f);
        int count = 0;
        for (int j = 0; j < numFiltersY; ++j) {
            for (int i = 0; i < numFiltersX && count < this.filters.length; ++i) {
                image.drawImage((Image)this.filters[count++].kernel.clone().normalise(), w * i + border, h * j + border);
            }
        }
        return image;
    }
}

