/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.filterbank.RootFilterSetFilterBank;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class MR8FilterBank
extends RootFilterSetFilterBank {
    @Override
    public void processImage(FImage image) {
        FImage[] allresponses = new FImage[this.filters.length];
        this.responses = new FImage[8];
        for (int i = 0; i < this.filters.length; ++i) {
            allresponses[i] = (FImage)image.process((SinglebandImageProcessor)this.filters[i]);
        }
        int allIndex = 0;
        int idx = 0;
        for (int type = 0; type < 2; ++type) {
            for (int scale = 0; scale < SCALES.length; ++scale) {
                this.responses[idx] = allresponses[allIndex];
                ++allIndex;
                for (int orient = 1; orient < 6; ++orient) {
                    for (int y = 0; y < image.height; ++y) {
                        for (int x = 0; x < image.width; ++x) {
                            this.responses[idx].pixels[y][x] = Math.max(this.responses[idx].pixels[y][x], allresponses[allIndex].pixels[y][x]);
                        }
                    }
                    ++allIndex;
                }
                ++idx;
            }
        }
        this.responses[idx++] = allresponses[allIndex++];
        this.responses[idx++] = allresponses[allIndex++];
    }
}

