/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.morphology;

import java.util.HashSet;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public class Dilate
implements ConnectedComponentProcessor,
KernelProcessor<Float, FImage> {
    protected StructuringElement element;
    protected int cx;
    protected int cy;
    protected int sw;
    protected int sh;

    public Dilate(StructuringElement se) {
        this.element = se;
        int[] sz = se.size();
        this.sw = sz[0];
        this.sh = sz[1];
        this.cx = this.sw / 2;
        this.cy = this.sh / 2;
    }

    public Dilate() {
        this(StructuringElement.BOX);
    }

    public void process(ConnectedComponent cc) {
        Rectangle cc_bb = cc.calculateRegularBoundingBox();
        HashSet<Pixel> newPixels = new HashSet<Pixel>();
        int j = (int)(cc_bb.y - (float)this.sh);
        while ((float)j <= cc_bb.y + (float)this.sh + cc_bb.height) {
            int i = (int)(cc_bb.x - (float)this.sw);
            while ((float)i <= cc_bb.x + (float)this.sw + cc_bb.width) {
                Pixel p = new Pixel(i, j);
                if (this.element.intersect(p, cc.getPixels()).size() >= 1) {
                    newPixels.add(p);
                }
                ++i;
            }
            ++j;
        }
        cc.getPixels().addAll(newPixels);
    }

    public int getKernelHeight() {
        return this.sh;
    }

    public int getKernelWidth() {
        return this.sw;
    }

    public Float processKernel(FImage patch) {
        int py;
        int px;
        for (Pixel p : this.element.positive) {
            px = this.cx - p.x;
            py = this.cy - p.y;
            if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 1.0f) continue;
            return Float.valueOf(1.0f);
        }
        for (Pixel p : this.element.negative) {
            px = this.cx - p.x;
            py = this.cy - p.y;
            if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 0.0f) continue;
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(patch.pixels[this.cy][this.cx]);
    }
}

