/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.image.processing.resize.ResizeFilterFunction;

public class Lanczos3Filter
implements ResizeFilterFunction {
    private double defaultSupport = 3.0;

    @Override
    public double getDefaultSupport() {
        return this.defaultSupport;
    }

    private double sinc(double x) {
        if ((x *= Math.PI) != 0.0) {
            return Math.sin(x) / x;
        }
        return 1.0;
    }

    @Override
    public double filter(double t) {
        if (t < 0.0) {
            t = -t;
        }
        if (t < 3.0) {
            return this.sinc(t) * this.sinc(t / 3.0);
        }
        return 0.0;
    }
}

