/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.resize.BasicFilter;
import org.openimaj.image.processing.resize.ResizeFilterFunction;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public class ResizeProcessor
implements SinglebandImageProcessor<Float, FImage> {
    private Mode mode = null;
    private float amount = 0.0f;
    private float newX;
    private float newY;
    private ResizeFilterFunction filterFunction = new BasicFilter();

    public ResizeProcessor(Mode mode) {
        this.mode = mode;
    }

    public ResizeProcessor(float amount, ResizeFilterFunction ff) {
        this.mode = Mode.SCALE;
        this.amount = amount;
        this.filterFunction = ff;
    }

    public ResizeProcessor(float newX, float newY, ResizeFilterFunction ff) {
        this.mode = Mode.ASPECT_RATIO;
        this.newX = newX;
        this.newY = newY;
        this.filterFunction = ff;
    }

    public ResizeProcessor(float amount) {
        this(amount, null);
    }

    public ResizeProcessor(float newX, float newY) {
        this(newX, newY, null);
    }

    public ResizeProcessor(int maxSize) {
        this.mode = Mode.MAX;
        this.newX = maxSize;
        this.newY = maxSize;
    }

    public ResizeProcessor(int maxSizeArea, boolean area) {
        this.mode = area ? Mode.MAX_AREA : Mode.MAX;
        this.newX = maxSizeArea;
        this.newY = maxSizeArea;
    }

    public ResizeProcessor(int newX, int newY, boolean aspectRatio) {
        this((float)newX, (float)newY, null);
        this.mode = aspectRatio ? Mode.ASPECT_RATIO : Mode.FIT;
    }

    public void processImage(FImage image) {
        switch (this.mode) {
            case DOUBLE: {
                ResizeProcessor.internalDoubleSize(image);
                break;
            }
            case HALF: {
                ResizeProcessor.internalHalfSize(image);
                break;
            }
            case FIT: {
                ResizeProcessor.zoom(image, (int)this.newX, (int)this.newY);
                break;
            }
            case SCALE: {
                this.newX = (float)image.width * this.amount;
                this.newY = (float)image.height * this.amount;
            }
            case ASPECT_RATIO: {
                ResizeProcessor.resample(image, (int)this.newX, (int)this.newY, true);
                break;
            }
            case MAX: {
                ResizeProcessor.resizeMax(image, (int)this.newX);
                break;
            }
            case MAX_AREA: {
                ResizeProcessor.resizeMaxArea(image, (int)this.newX);
                break;
            }
            case NONE: {
                return;
            }
            default: {
                ResizeProcessor.zoom(image, (int)this.newX, (int)this.newY, this.filterFunction, this.filterFunction.getDefaultSupport());
            }
        }
    }

    public static FImage resizeMax(FImage image, int maxDim) {
        int newWidth;
        int newHeight;
        int width = image.width;
        int height = image.height;
        if (width < maxDim && height < maxDim) {
            return image;
        }
        if (width < height) {
            newHeight = maxDim;
            float resizeRatio = (float)maxDim / (float)height;
            newWidth = (int)((float)width * resizeRatio);
        } else {
            newWidth = maxDim;
            float resizeRatio = (float)maxDim / (float)width;
            newHeight = (int)((float)height * resizeRatio);
        }
        ResizeProcessor.zoom(image, newWidth, newHeight);
        return image;
    }

    public static FImage resizeMaxArea(FImage image, int maxArea) {
        int width = image.width;
        int height = image.height;
        int area = width * height;
        if (area < maxArea) {
            return image;
        }
        float whRatio = width / height;
        int newWidth = (int)Math.sqrt((float)maxArea * whRatio);
        int newHeight = maxArea / newWidth;
        ResizeProcessor.zoom(image, newWidth, newHeight);
        return image;
    }

    public static <I extends Image<?, I>> I doubleSize(I image) {
        return (I)((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor(Mode.DOUBLE));
    }

    public static FImage doubleSize(FImage image) {
        int nheight = 2 * image.height - 2;
        int nwidth = 2 * image.width - 2;
        FImage newimage = new FImage(nwidth, nheight);
        float[][] im = image.pixels;
        float[][] tmp = newimage.pixels;
        for (int y = 0; y < image.height - 1; ++y) {
            for (int x = 0; x < image.width - 1; ++x) {
                int y2 = 2 * y;
                int x2 = 2 * x;
                tmp[y2][x2] = im[y][x];
                tmp[y2 + 1][x2] = 0.5f * (im[y][x] + im[y + 1][x]);
                tmp[y2][x2 + 1] = 0.5f * (im[y][x] + im[y][x + 1]);
                tmp[y2 + 1][x2 + 1] = 0.25f * (im[y][x] + im[y + 1][x] + im[y][x + 1] + im[y + 1][x + 1]);
            }
        }
        return newimage;
    }

    protected static void internalDoubleSize(FImage image) {
        image.internalAssign(ResizeProcessor.doubleSize(image));
    }

    public static <I extends Image<?, I>> I halfSize(I image) {
        return (I)((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor(Mode.HALF));
    }

    public static FImage halfSize(FImage image) {
        int newheight = image.height / 2;
        int newwidth = image.width / 2;
        FImage newimage = new FImage(newwidth, newheight);
        float[][] im = image.pixels;
        float[][] tmp = newimage.pixels;
        int y = 0;
        int yi = 0;
        while (y < newheight) {
            int x = 0;
            int xi = 0;
            while (x < newwidth) {
                tmp[y][x] = im[yi][xi];
                ++x;
                xi += 2;
            }
            ++y;
            yi += 2;
        }
        return newimage;
    }

    protected static void internalHalfSize(FImage image) {
        image.internalAssign(ResizeProcessor.halfSize(image));
    }

    public static FImage resample(FImage in, int newX, int newY) {
        return ResizeProcessor.resample(in.clone(), newX, newY, false);
    }

    public static FImage resample(FImage in, int newX, int newY, boolean aspect) {
        int nx = newX;
        int ny = newY;
        if (aspect) {
            if (ny > nx) {
                nx = (int)((double)in.width * ((double)ny / (double)in.height));
            } else {
                ny = (int)((double)in.height * ((double)nx / (double)in.width));
            }
        }
        ResizeProcessor.zoom(in, nx, ny);
        return in;
    }

    private static float clamp(float v, float l, float h) {
        return v < l ? l : (v > h ? h : v);
    }

    private static int calc_x_contrib(PixelContributions contribX, double xscale, double fwidth, int dstwidth, int srcwidth, ResizeFilterFunction filterf, int i) {
        if (xscale < 1.0) {
            double width = fwidth / xscale;
            double fscale = 1.0 / xscale;
            contribX.numberOfContributors = 0;
            contribX.contributions = new PixelContribution[(int)Math.round(width * 2.0 + 1.0)];
            double center = (double)i / xscale;
            double left = Math.ceil(center - width);
            double right = Math.floor(center + width);
            int j = (int)left;
            while ((double)j <= right) {
                double weight = center - (double)j;
                weight = filterf.filter(weight / fscale) / fscale;
                int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                ++contribX.numberOfContributors;
                contribX.contributions[k] = new PixelContribution();
                contribX.contributions[k].pixel = n;
                contribX.contributions[k].weight = weight;
                ++j;
            }
        } else {
            contribX.numberOfContributors = 0;
            contribX.contributions = new PixelContribution[(int)Math.round(fwidth * 2.0 + 1.0)];
            double center = (double)i / xscale;
            double left = Math.ceil(center - fwidth);
            double right = Math.floor(center + fwidth);
            int j = (int)left;
            while ((double)j <= right) {
                double weight = center - (double)j;
                weight = filterf.filter(weight);
                int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                ++contribX.numberOfContributors;
                contribX.contributions[k] = new PixelContribution();
                contribX.contributions[k].pixel = n;
                contribX.contributions[k].weight = weight;
                ++j;
            }
        }
        return 0;
    }

    public static int zoom(FImage in, int newX, int newY) {
        BasicFilter filter = new BasicFilter();
        return ResizeProcessor.zoom(in, newX, newY, filter, filter.getDefaultSupport());
    }

    public static int zoom(FImage in, int newX, int newY, ResizeFilterFunction filterf, double fwidth) {
        FImage dst = new FImage(newX, newY);
        int val = ResizeProcessor.zoom(in, dst, filterf, fwidth);
        if (val != -1) {
            in.internalAssign(dst);
        }
        return val;
    }

    public static int zoom(FImage in, FImage dst, ResizeFilterFunction filterf, double fwidth) {
        int n;
        double weight;
        int j;
        double right;
        double left;
        double center;
        int i;
        int nRet = -1;
        FImage src = in;
        Float[] tmp = new Float[src.height];
        double xscale = (double)dst.width / (double)src.width;
        PixelContributions[] contribY = new PixelContributions[dst.height];
        double yscale = (double)dst.height / (double)src.height;
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            for (i = 0; i < dst.height; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(width * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - width);
                right = Math.floor(center + width);
                j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    n = j < 0 ? -j : (j >= src.height ? src.height - j + src.height - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        } else {
            for (i = 0; i < dst.height; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(fwidth * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - fwidth);
                right = Math.floor(center + fwidth);
                j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight);
                    n = j < 0 ? -j : (j >= src.height ? src.height - j + src.height - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        }
        for (int xx = 0; xx < dst.width; ++xx) {
            float pel2;
            int j2;
            float pel;
            boolean bPelDelta;
            PixelContributions contribX = new PixelContributions();
            if (0 != ResizeProcessor.calc_x_contrib(contribX, xscale, fwidth, dst.width, src.width, filterf, xx)) {
                return 0;
            }
            for (int k = 0; k < src.height; ++k) {
                weight = 0.0;
                bPelDelta = false;
                pel = src.pixels[k][contribX.contributions[0].pixel];
                for (j2 = 0; j2 < contribX.numberOfContributors; ++j2) {
                    pel2 = src.pixels[k][contribX.contributions[j2].pixel];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribX.contributions[j2].weight;
                }
                weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                tmp[k] = Float.valueOf(ResizeProcessor.clamp((float)weight, 0.0f, 1.0f));
            }
            for (int i2 = 0; i2 < dst.height; ++i2) {
                weight = 0.0;
                bPelDelta = false;
                pel = tmp[contribY[i2].contributions[0].pixel].floatValue();
                for (j2 = 0; j2 < contribY[i2].numberOfContributors; ++j2) {
                    pel2 = tmp[contribY[i2].contributions[j2].pixel].floatValue();
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribY[i2].contributions[j2].weight;
                }
                weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                dst.pixels[i2][xx] = ResizeProcessor.clamp((float)weight, 0.0f, 1.0f);
            }
        }
        nRet = 0;
        return nRet;
    }

    public static int zoom(FImage in, Rectangle inRect, FImage dst, Rectangle dstRect) {
        BasicFilter filter = new BasicFilter();
        return ResizeProcessor.zoom(in, inRect, dst, dstRect, filter, filter.getDefaultSupport());
    }

    public static int zoom(FImage in, Rectangle inRect, FImage dst, Rectangle dstRect, ResizeFilterFunction filterf, double fwidth) {
        int n;
        double weight;
        int j;
        double right;
        double left;
        double center;
        int i;
        if (!in.getBounds().isInside(inRect) || !dst.getBounds().isInside(dstRect)) {
            return -1;
        }
        int nRet = -1;
        FImage src = in;
        int srcX = (int)inRect.x;
        int srcY = (int)inRect.y;
        int srcWidth = (int)inRect.width;
        int srcHeight = (int)inRect.height;
        int dstX = (int)dstRect.x;
        int dstY = (int)dstRect.y;
        int dstWidth = (int)dstRect.width;
        int dstHeight = (int)dstRect.height;
        Float[] tmp = new Float[srcHeight];
        double xscale = (double)dstWidth / (double)srcWidth;
        PixelContributions[] contribY = new PixelContributions[dstHeight];
        double yscale = (double)dstHeight / (double)srcHeight;
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            for (i = 0; i < dstHeight; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(width * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - width);
                right = Math.floor(center + width);
                j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        } else {
            for (i = 0; i < dstHeight; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(fwidth * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - fwidth);
                right = Math.floor(center + fwidth);
                j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight);
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        }
        for (int xx = 0; xx < dstWidth; ++xx) {
            float pel2;
            int j2;
            float pel;
            boolean bPelDelta;
            PixelContributions contribX = new PixelContributions();
            if (0 != ResizeProcessor.calc_x_contrib(contribX, xscale, fwidth, dstWidth, srcWidth, filterf, xx)) {
                return 0;
            }
            for (int k = 0; k < srcHeight; ++k) {
                weight = 0.0;
                bPelDelta = false;
                pel = src.pixels[k + srcY][contribX.contributions[0].pixel + srcX];
                for (j2 = 0; j2 < contribX.numberOfContributors; ++j2) {
                    pel2 = src.pixels[k + srcY][contribX.contributions[j2].pixel + srcX];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribX.contributions[j2].weight;
                }
                weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                tmp[k] = Float.valueOf(ResizeProcessor.clamp((float)weight, 0.0f, 1.0f));
            }
            for (int i2 = 0; i2 < dstHeight; ++i2) {
                weight = 0.0;
                bPelDelta = false;
                pel = tmp[contribY[i2].contributions[0].pixel].floatValue();
                for (j2 = 0; j2 < contribY[i2].numberOfContributors; ++j2) {
                    pel2 = tmp[contribY[i2].contributions[j2].pixel].floatValue();
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribY[i2].contributions[j2].weight;
                }
                weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                dst.pixels[i2 + dstY][xx + dstX] = ResizeProcessor.clamp((float)weight, 0.0f, 1.0f);
            }
        }
        nRet = 0;
        return nRet;
    }

    private static class PixelContributions {
        int numberOfContributors;
        PixelContribution[] contributions;

        private PixelContributions() {
        }
    }

    private static class PixelContribution {
        int pixel;
        double weight;

        private PixelContribution() {
        }
    }

    public static enum Mode {
        DOUBLE,
        HALF,
        SCALE,
        ASPECT_RATIO,
        FIT,
        MAX,
        MAX_AREA,
        NONE;

    }
}

